/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DataCompressionType;
import software.amazon.awssdk.services.fsx.model.DataRepositoryConfiguration;
import software.amazon.awssdk.services.fsx.model.DriveCacheType;
import software.amazon.awssdk.services.fsx.model.LustreDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LustreFileSystemConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LustreFileSystemConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::weeklyMaintenanceStartTime)).setter(LustreFileSystemConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<DataRepositoryConfiguration> DATA_REPOSITORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataRepositoryConfiguration").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::dataRepositoryConfiguration)).setter(LustreFileSystemConfiguration.setter(Builder::dataRepositoryConfiguration)).constructor(DataRepositoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryConfiguration").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::deploymentTypeAsString)).setter(LustreFileSystemConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerUnitStorageThroughput").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::perUnitStorageThroughput)).setter(LustreFileSystemConfiguration.setter(Builder::perUnitStorageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build()}).build();
    private static final SdkField<String> MOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountName").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::mountName)).setter(LustreFileSystemConfiguration.setter(Builder::mountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountName").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::dailyAutomaticBackupStartTime)).setter(LustreFileSystemConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::automaticBackupRetentionDays)).setter(LustreFileSystemConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::copyTagsToBackups)).setter(LustreFileSystemConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<String> DRIVE_CACHE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DriveCacheType").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::driveCacheTypeAsString)).setter(LustreFileSystemConfiguration.setter(Builder::driveCacheType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriveCacheType").build()}).build();
    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataCompressionType").getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::dataCompressionTypeAsString)).setter(LustreFileSystemConfiguration.setter(Builder::dataCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEEKLY_MAINTENANCE_START_TIME_FIELD, DATA_REPOSITORY_CONFIGURATION_FIELD, DEPLOYMENT_TYPE_FIELD, PER_UNIT_STORAGE_THROUGHPUT_FIELD, MOUNT_NAME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, DRIVE_CACHE_TYPE_FIELD, DATA_COMPRESSION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String weeklyMaintenanceStartTime;
    private final DataRepositoryConfiguration dataRepositoryConfiguration;
    private final String deploymentType;
    private final Integer perUnitStorageThroughput;
    private final String mountName;
    private final String dailyAutomaticBackupStartTime;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;
    private final String driveCacheType;
    private final String dataCompressionType;

    private LustreFileSystemConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dataRepositoryConfiguration = builder.dataRepositoryConfiguration;
        this.deploymentType = builder.deploymentType;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.mountName = builder.mountName;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.driveCacheType = builder.driveCacheType;
        this.dataCompressionType = builder.dataCompressionType;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final DataRepositoryConfiguration dataRepositoryConfiguration() {
        return this.dataRepositoryConfiguration;
    }

    public final LustreDeploymentType deploymentType() {
        return LustreDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final Integer perUnitStorageThroughput() {
        return this.perUnitStorageThroughput;
    }

    public final String mountName() {
        return this.mountName;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final DriveCacheType driveCacheType() {
        return DriveCacheType.fromValue(this.driveCacheType);
    }

    public final String driveCacheTypeAsString() {
        return this.driveCacheType;
    }

    public final DataCompressionType dataCompressionType() {
        return DataCompressionType.fromValue(this.dataCompressionType);
    }

    public final String dataCompressionTypeAsString() {
        return this.dataCompressionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRepositoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.driveCacheTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCompressionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LustreFileSystemConfiguration)) {
            return false;
        }
        LustreFileSystemConfiguration other = (LustreFileSystemConfiguration)obj;
        return Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.dataRepositoryConfiguration(), other.dataRepositoryConfiguration()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.perUnitStorageThroughput(), other.perUnitStorageThroughput()) && Objects.equals(this.mountName(), other.mountName()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && Objects.equals(this.driveCacheTypeAsString(), other.driveCacheTypeAsString()) && Objects.equals(this.dataCompressionTypeAsString(), other.dataCompressionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LustreFileSystemConfiguration").add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DataRepositoryConfiguration", (Object)this.dataRepositoryConfiguration()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("PerUnitStorageThroughput", (Object)this.perUnitStorageThroughput()).add("MountName", (Object)this.mountName()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("DriveCacheType", (Object)this.driveCacheTypeAsString()).add("DataCompressionType", (Object)this.dataCompressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DataRepositoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataRepositoryConfiguration()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "PerUnitStorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.perUnitStorageThroughput()));
            }
            case "MountName": {
                return Optional.ofNullable(clazz.cast(this.mountName()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "DriveCacheType": {
                return Optional.ofNullable(clazz.cast(this.driveCacheTypeAsString()));
            }
            case "DataCompressionType": {
                return Optional.ofNullable(clazz.cast(this.dataCompressionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LustreFileSystemConfiguration, T> g) {
        return obj -> g.apply((LustreFileSystemConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String weeklyMaintenanceStartTime;
        private DataRepositoryConfiguration dataRepositoryConfiguration;
        private String deploymentType;
        private Integer perUnitStorageThroughput;
        private String mountName;
        private String dailyAutomaticBackupStartTime;
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;
        private String driveCacheType;
        private String dataCompressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(LustreFileSystemConfiguration model) {
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.dataRepositoryConfiguration(model.dataRepositoryConfiguration);
            this.deploymentType(model.deploymentType);
            this.perUnitStorageThroughput(model.perUnitStorageThroughput);
            this.mountName(model.mountName);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.driveCacheType(model.driveCacheType);
            this.dataCompressionType(model.dataCompressionType);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        @Transient
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DataRepositoryConfiguration.Builder getDataRepositoryConfiguration() {
            return this.dataRepositoryConfiguration != null ? this.dataRepositoryConfiguration.toBuilder() : null;
        }

        public final void setDataRepositoryConfiguration(DataRepositoryConfiguration.BuilderImpl dataRepositoryConfiguration) {
            this.dataRepositoryConfiguration = dataRepositoryConfiguration != null ? dataRepositoryConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataRepositoryConfiguration(DataRepositoryConfiguration dataRepositoryConfiguration) {
            this.dataRepositoryConfiguration = dataRepositoryConfiguration;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        @Transient
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        @Transient
        public final Builder deploymentType(LustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final Integer getPerUnitStorageThroughput() {
            return this.perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        @Transient
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final String getMountName() {
            return this.mountName;
        }

        public final void setMountName(String mountName) {
            this.mountName = mountName;
        }

        @Override
        @Transient
        public final Builder mountName(String mountName) {
            this.mountName = mountName;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        @Transient
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        @Transient
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        @Transient
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final String getDriveCacheType() {
            return this.driveCacheType;
        }

        public final void setDriveCacheType(String driveCacheType) {
            this.driveCacheType = driveCacheType;
        }

        @Override
        @Transient
        public final Builder driveCacheType(String driveCacheType) {
            this.driveCacheType = driveCacheType;
            return this;
        }

        @Override
        @Transient
        public final Builder driveCacheType(DriveCacheType driveCacheType) {
            this.driveCacheType(driveCacheType == null ? null : driveCacheType.toString());
            return this;
        }

        public final String getDataCompressionType() {
            return this.dataCompressionType;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        @Transient
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        @Transient
        public final Builder dataCompressionType(DataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public LustreFileSystemConfiguration build() {
            return new LustreFileSystemConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LustreFileSystemConfiguration> {
        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder dataRepositoryConfiguration(DataRepositoryConfiguration var1);

        default public Builder dataRepositoryConfiguration(Consumer<DataRepositoryConfiguration.Builder> dataRepositoryConfiguration) {
            return this.dataRepositoryConfiguration((DataRepositoryConfiguration)((DataRepositoryConfiguration.Builder)DataRepositoryConfiguration.builder().applyMutation(dataRepositoryConfiguration)).build());
        }

        public Builder deploymentType(String var1);

        public Builder deploymentType(LustreDeploymentType var1);

        public Builder perUnitStorageThroughput(Integer var1);

        public Builder mountName(String var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder driveCacheType(String var1);

        public Builder driveCacheType(DriveCacheType var1);

        public Builder dataCompressionType(String var1);

        public Builder dataCompressionType(DataCompressionType var1);
    }
}

