/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AlternateDNSNamesCopier;
import software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryConfiguration;
import software.amazon.awssdk.services.fsx.model.WindowsAuditLogCreateConfiguration;
import software.amazon.awssdk.services.fsx.model.WindowsDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFileSystemWindowsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateFileSystemWindowsConfiguration> {
    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveDirectoryId").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::activeDirectoryId)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::activeDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()}).build();
    private static final SdkField<SelfManagedActiveDirectoryConfiguration> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedActiveDirectoryConfiguration").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::selfManagedActiveDirectoryConfiguration)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::selfManagedActiveDirectoryConfiguration)).constructor(SelfManagedActiveDirectoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedActiveDirectoryConfiguration").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::deploymentTypeAsString)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<String> PREFERRED_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredSubnetId").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::preferredSubnetId)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::preferredSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredSubnetId").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::throughputCapacity)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::weeklyMaintenanceStartTime)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::dailyAutomaticBackupStartTime)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::automaticBackupRetentionDays)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::copyTagsToBackups)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<List<String>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aliases").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::aliases)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WindowsAuditLogCreateConfiguration> AUDIT_LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuditLogConfiguration").getter(CreateFileSystemWindowsConfiguration.getter(CreateFileSystemWindowsConfiguration::auditLogConfiguration)).setter(CreateFileSystemWindowsConfiguration.setter(Builder::auditLogConfiguration)).constructor(WindowsAuditLogCreateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_ID_FIELD, SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD, DEPLOYMENT_TYPE_FIELD, PREFERRED_SUBNET_ID_FIELD, THROUGHPUT_CAPACITY_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, ALIASES_FIELD, AUDIT_LOG_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activeDirectoryId;
    private final SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration;
    private final String deploymentType;
    private final String preferredSubnetId;
    private final Integer throughputCapacity;
    private final String weeklyMaintenanceStartTime;
    private final String dailyAutomaticBackupStartTime;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;
    private final List<String> aliases;
    private final WindowsAuditLogCreateConfiguration auditLogConfiguration;

    private CreateFileSystemWindowsConfiguration(BuilderImpl builder) {
        this.activeDirectoryId = builder.activeDirectoryId;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
        this.deploymentType = builder.deploymentType;
        this.preferredSubnetId = builder.preferredSubnetId;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.aliases = builder.aliases;
        this.auditLogConfiguration = builder.auditLogConfiguration;
    }

    public final String activeDirectoryId() {
        return this.activeDirectoryId;
    }

    public final SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration() {
        return this.selfManagedActiveDirectoryConfiguration;
    }

    public final WindowsDeploymentType deploymentType() {
        return WindowsDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final String preferredSubnetId() {
        return this.preferredSubnetId;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<String> aliases() {
        return this.aliases;
    }

    public final WindowsAuditLogCreateConfiguration auditLogConfiguration() {
        return this.auditLogConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedActiveDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.auditLogConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemWindowsConfiguration)) {
            return false;
        }
        CreateFileSystemWindowsConfiguration other = (CreateFileSystemWindowsConfiguration)obj;
        return Objects.equals(this.activeDirectoryId(), other.activeDirectoryId()) && Objects.equals(this.selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.preferredSubnetId(), other.preferredSubnetId()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.auditLogConfiguration(), other.auditLogConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFileSystemWindowsConfiguration").add("ActiveDirectoryId", (Object)this.activeDirectoryId()).add("SelfManagedActiveDirectoryConfiguration", (Object)this.selfManagedActiveDirectoryConfiguration()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("PreferredSubnetId", (Object)this.preferredSubnetId()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("Aliases", this.hasAliases() ? this.aliases() : null).add("AuditLogConfiguration", (Object)this.auditLogConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveDirectoryId": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryId()));
            }
            case "SelfManagedActiveDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.selfManagedActiveDirectoryConfiguration()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "PreferredSubnetId": {
                return Optional.ofNullable(clazz.cast(this.preferredSubnetId()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "AuditLogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.auditLogConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemWindowsConfiguration, T> g) {
        return obj -> g.apply((CreateFileSystemWindowsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeDirectoryId;
        private SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration;
        private String deploymentType;
        private String preferredSubnetId;
        private Integer throughputCapacity;
        private String weeklyMaintenanceStartTime;
        private String dailyAutomaticBackupStartTime;
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;
        private List<String> aliases = DefaultSdkAutoConstructList.getInstance();
        private WindowsAuditLogCreateConfiguration auditLogConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemWindowsConfiguration model) {
            this.activeDirectoryId(model.activeDirectoryId);
            this.selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
            this.deploymentType(model.deploymentType);
            this.preferredSubnetId(model.preferredSubnetId);
            this.throughputCapacity(model.throughputCapacity);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.aliases(model.aliases);
            this.auditLogConfiguration(model.auditLogConfiguration);
        }

        public final String getActiveDirectoryId() {
            return this.activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        public final SelfManagedActiveDirectoryConfiguration.Builder getSelfManagedActiveDirectoryConfiguration() {
            return this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfiguration.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.build() : null;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(WindowsDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getPreferredSubnetId() {
            return this.preferredSubnetId;
        }

        @Override
        public final Builder preferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
            return this;
        }

        public final void setPreferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        public final Collection<String> getAliases() {
            if (this.aliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliases;
        }

        @Override
        public final Builder aliases(Collection<String> aliases) {
            this.aliases = AlternateDNSNamesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(String ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        public final void setAliases(Collection<String> aliases) {
            this.aliases = AlternateDNSNamesCopier.copy(aliases);
        }

        public final WindowsAuditLogCreateConfiguration.Builder getAuditLogConfiguration() {
            return this.auditLogConfiguration != null ? this.auditLogConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder auditLogConfiguration(WindowsAuditLogCreateConfiguration auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration;
            return this;
        }

        public final void setAuditLogConfiguration(WindowsAuditLogCreateConfiguration.BuilderImpl auditLogConfiguration) {
            this.auditLogConfiguration = auditLogConfiguration != null ? auditLogConfiguration.build() : null;
        }

        public CreateFileSystemWindowsConfiguration build() {
            return new CreateFileSystemWindowsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateFileSystemWindowsConfiguration> {
        public Builder activeDirectoryId(String var1);

        public Builder selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfiguration var1);

        default public Builder selfManagedActiveDirectoryConfiguration(Consumer<SelfManagedActiveDirectoryConfiguration.Builder> selfManagedActiveDirectoryConfiguration) {
            return this.selfManagedActiveDirectoryConfiguration((SelfManagedActiveDirectoryConfiguration)((SelfManagedActiveDirectoryConfiguration.Builder)SelfManagedActiveDirectoryConfiguration.builder().applyMutation(selfManagedActiveDirectoryConfiguration)).build());
        }

        public Builder deploymentType(String var1);

        public Builder deploymentType(WindowsDeploymentType var1);

        public Builder preferredSubnetId(String var1);

        public Builder throughputCapacity(Integer var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder aliases(Collection<String> var1);

        public Builder aliases(String ... var1);

        public Builder auditLogConfiguration(WindowsAuditLogCreateConfiguration var1);

        default public Builder auditLogConfiguration(Consumer<WindowsAuditLogCreateConfiguration.Builder> auditLogConfiguration) {
            return this.auditLogConfiguration((WindowsAuditLogCreateConfiguration)((WindowsAuditLogCreateConfiguration.Builder)WindowsAuditLogCreateConfiguration.builder().applyMutation(auditLogConfiguration)).build());
        }
    }
}

