/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.AdministrativeActionFailureDetails;
import software.amazon.awssdk.services.fsx.model.AdministrativeActionType;
import software.amazon.awssdk.services.fsx.model.FileSystem;
import software.amazon.awssdk.services.fsx.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdministrativeAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdministrativeAction> {
    private static final SdkField<String> ADMINISTRATIVE_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdministrativeActionType").getter(AdministrativeAction.getter(AdministrativeAction::administrativeActionTypeAsString)).setter(AdministrativeAction.setter(Builder::administrativeActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActionType").build()}).build();
    private static final SdkField<Integer> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgressPercent").getter(AdministrativeAction.getter(AdministrativeAction::progressPercent)).setter(AdministrativeAction.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()}).build();
    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestTime").getter(AdministrativeAction.getter(AdministrativeAction::requestTime)).setter(AdministrativeAction.setter(Builder::requestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AdministrativeAction.getter(AdministrativeAction::statusAsString)).setter(AdministrativeAction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<FileSystem> TARGET_FILE_SYSTEM_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetFileSystemValues").getter(AdministrativeAction.getter(AdministrativeAction::targetFileSystemValues)).setter(AdministrativeAction.setter(Builder::targetFileSystemValues)).constructor(FileSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetFileSystemValues").build()}).build();
    private static final SdkField<AdministrativeActionFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(AdministrativeAction.getter(AdministrativeAction::failureDetails)).setter(AdministrativeAction.setter(Builder::failureDetails)).constructor(AdministrativeActionFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMINISTRATIVE_ACTION_TYPE_FIELD, PROGRESS_PERCENT_FIELD, REQUEST_TIME_FIELD, STATUS_FIELD, TARGET_FILE_SYSTEM_VALUES_FIELD, FAILURE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String administrativeActionType;
    private final Integer progressPercent;
    private final Instant requestTime;
    private final String status;
    private final FileSystem targetFileSystemValues;
    private final AdministrativeActionFailureDetails failureDetails;

    private AdministrativeAction(BuilderImpl builder) {
        this.administrativeActionType = builder.administrativeActionType;
        this.progressPercent = builder.progressPercent;
        this.requestTime = builder.requestTime;
        this.status = builder.status;
        this.targetFileSystemValues = builder.targetFileSystemValues;
        this.failureDetails = builder.failureDetails;
    }

    public final AdministrativeActionType administrativeActionType() {
        return AdministrativeActionType.fromValue(this.administrativeActionType);
    }

    public final String administrativeActionTypeAsString() {
        return this.administrativeActionType;
    }

    public final Integer progressPercent() {
        return this.progressPercent;
    }

    public final Instant requestTime() {
        return this.requestTime;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final FileSystem targetFileSystemValues() {
        return this.targetFileSystemValues;
    }

    public final AdministrativeActionFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.administrativeActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetFileSystemValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdministrativeAction)) {
            return false;
        }
        AdministrativeAction other = (AdministrativeAction)obj;
        return Objects.equals(this.administrativeActionTypeAsString(), other.administrativeActionTypeAsString()) && Objects.equals(this.progressPercent(), other.progressPercent()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetFileSystemValues(), other.targetFileSystemValues()) && Objects.equals(this.failureDetails(), other.failureDetails());
    }

    public final String toString() {
        return ToString.builder((String)"AdministrativeAction").add("AdministrativeActionType", (Object)this.administrativeActionTypeAsString()).add("ProgressPercent", (Object)this.progressPercent()).add("RequestTime", (Object)this.requestTime()).add("Status", (Object)this.statusAsString()).add("TargetFileSystemValues", (Object)this.targetFileSystemValues()).add("FailureDetails", (Object)this.failureDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdministrativeActionType": {
                return Optional.ofNullable(clazz.cast(this.administrativeActionTypeAsString()));
            }
            case "ProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
            case "RequestTime": {
                return Optional.ofNullable(clazz.cast(this.requestTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetFileSystemValues": {
                return Optional.ofNullable(clazz.cast(this.targetFileSystemValues()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdministrativeAction, T> g) {
        return obj -> g.apply((AdministrativeAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String administrativeActionType;
        private Integer progressPercent;
        private Instant requestTime;
        private String status;
        private FileSystem targetFileSystemValues;
        private AdministrativeActionFailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AdministrativeAction model) {
            this.administrativeActionType(model.administrativeActionType);
            this.progressPercent(model.progressPercent);
            this.requestTime(model.requestTime);
            this.status(model.status);
            this.targetFileSystemValues(model.targetFileSystemValues);
            this.failureDetails(model.failureDetails);
        }

        public final String getAdministrativeActionType() {
            return this.administrativeActionType;
        }

        public final void setAdministrativeActionType(String administrativeActionType) {
            this.administrativeActionType = administrativeActionType;
        }

        @Override
        @Transient
        public final Builder administrativeActionType(String administrativeActionType) {
            this.administrativeActionType = administrativeActionType;
            return this;
        }

        @Override
        @Transient
        public final Builder administrativeActionType(AdministrativeActionType administrativeActionType) {
            this.administrativeActionType(administrativeActionType == null ? null : administrativeActionType.toString());
            return this;
        }

        public final Integer getProgressPercent() {
            return this.progressPercent;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        @Transient
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        @Transient
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final FileSystem.Builder getTargetFileSystemValues() {
            return this.targetFileSystemValues != null ? this.targetFileSystemValues.toBuilder() : null;
        }

        public final void setTargetFileSystemValues(FileSystem.BuilderImpl targetFileSystemValues) {
            this.targetFileSystemValues = targetFileSystemValues != null ? targetFileSystemValues.build() : null;
        }

        @Override
        @Transient
        public final Builder targetFileSystemValues(FileSystem targetFileSystemValues) {
            this.targetFileSystemValues = targetFileSystemValues;
            return this;
        }

        public final AdministrativeActionFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(AdministrativeActionFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder failureDetails(AdministrativeActionFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public AdministrativeAction build() {
            return new AdministrativeAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdministrativeAction> {
        public Builder administrativeActionType(String var1);

        public Builder administrativeActionType(AdministrativeActionType var1);

        public Builder progressPercent(Integer var1);

        public Builder requestTime(Instant var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder targetFileSystemValues(FileSystem var1);

        default public Builder targetFileSystemValues(Consumer<FileSystem.Builder> targetFileSystemValues) {
            return this.targetFileSystemValues((FileSystem)((FileSystem.Builder)FileSystem.builder().applyMutation(targetFileSystemValues)).build());
        }

        public Builder failureDetails(AdministrativeActionFailureDetails var1);

        default public Builder failureDetails(Consumer<AdministrativeActionFailureDetails.Builder> failureDetails) {
            return this.failureDetails((AdministrativeActionFailureDetails)((AdministrativeActionFailureDetails.Builder)AdministrativeActionFailureDetails.builder().applyMutation(failureDetails)).build());
        }
    }
}

