/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.CreateSvmActiveDirectoryConfiguration;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStorageVirtualMachineRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CreateStorageVirtualMachineRequest> {
    private static final SdkField<CreateSvmActiveDirectoryConfiguration> ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveDirectoryConfiguration").getter(CreateStorageVirtualMachineRequest.getter(CreateStorageVirtualMachineRequest::activeDirectoryConfiguration)).setter(CreateStorageVirtualMachineRequest.setter(Builder::activeDirectoryConfiguration)).constructor(CreateSvmActiveDirectoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateStorageVirtualMachineRequest.getter(CreateStorageVirtualMachineRequest::clientRequestToken)).setter(CreateStorageVirtualMachineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(CreateStorageVirtualMachineRequest.getter(CreateStorageVirtualMachineRequest::fileSystemId)).setter(CreateStorageVirtualMachineRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateStorageVirtualMachineRequest.getter(CreateStorageVirtualMachineRequest::name)).setter(CreateStorageVirtualMachineRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SVM_ADMIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SvmAdminPassword").getter(CreateStorageVirtualMachineRequest.getter(CreateStorageVirtualMachineRequest::svmAdminPassword)).setter(CreateStorageVirtualMachineRequest.setter(Builder::svmAdminPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SvmAdminPassword").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateStorageVirtualMachineRequest.getter(CreateStorageVirtualMachineRequest::tags)).setter(CreateStorageVirtualMachineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROOT_VOLUME_SECURITY_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootVolumeSecurityStyle").getter(CreateStorageVirtualMachineRequest.getter(CreateStorageVirtualMachineRequest::rootVolumeSecurityStyleAsString)).setter(CreateStorageVirtualMachineRequest.setter(Builder::rootVolumeSecurityStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeSecurityStyle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, NAME_FIELD, SVM_ADMIN_PASSWORD_FIELD, TAGS_FIELD, ROOT_VOLUME_SECURITY_STYLE_FIELD));
    private final CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;
    private final String clientRequestToken;
    private final String fileSystemId;
    private final String name;
    private final String svmAdminPassword;
    private final List<Tag> tags;
    private final String rootVolumeSecurityStyle;

    private CreateStorageVirtualMachineRequest(BuilderImpl builder) {
        super(builder);
        this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
        this.clientRequestToken = builder.clientRequestToken;
        this.fileSystemId = builder.fileSystemId;
        this.name = builder.name;
        this.svmAdminPassword = builder.svmAdminPassword;
        this.tags = builder.tags;
        this.rootVolumeSecurityStyle = builder.rootVolumeSecurityStyle;
    }

    public final CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration() {
        return this.activeDirectoryConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String name() {
        return this.name;
    }

    public final String svmAdminPassword() {
        return this.svmAdminPassword;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final StorageVirtualMachineRootVolumeSecurityStyle rootVolumeSecurityStyle() {
        return StorageVirtualMachineRootVolumeSecurityStyle.fromValue(this.rootVolumeSecurityStyle);
    }

    public final String rootVolumeSecurityStyleAsString() {
        return this.rootVolumeSecurityStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.svmAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeSecurityStyleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageVirtualMachineRequest)) {
            return false;
        }
        CreateStorageVirtualMachineRequest other = (CreateStorageVirtualMachineRequest)((Object)obj);
        return Objects.equals(this.activeDirectoryConfiguration(), other.activeDirectoryConfiguration()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.svmAdminPassword(), other.svmAdminPassword()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.rootVolumeSecurityStyleAsString(), other.rootVolumeSecurityStyleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStorageVirtualMachineRequest").add("ActiveDirectoryConfiguration", (Object)this.activeDirectoryConfiguration()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("FileSystemId", (Object)this.fileSystemId()).add("Name", (Object)this.name()).add("SvmAdminPassword", (Object)(this.svmAdminPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).add("RootVolumeSecurityStyle", (Object)this.rootVolumeSecurityStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryConfiguration()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SvmAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.svmAdminPassword()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RootVolumeSecurityStyle": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeSecurityStyleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorageVirtualMachineRequest, T> g) {
        return obj -> g.apply((CreateStorageVirtualMachineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;
        private String clientRequestToken;
        private String fileSystemId;
        private String name;
        private String svmAdminPassword;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String rootVolumeSecurityStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorageVirtualMachineRequest model) {
            super(model);
            this.activeDirectoryConfiguration(model.activeDirectoryConfiguration);
            this.clientRequestToken(model.clientRequestToken);
            this.fileSystemId(model.fileSystemId);
            this.name(model.name);
            this.svmAdminPassword(model.svmAdminPassword);
            this.tags(model.tags);
            this.rootVolumeSecurityStyle(model.rootVolumeSecurityStyle);
        }

        public final CreateSvmActiveDirectoryConfiguration.Builder getActiveDirectoryConfiguration() {
            return this.activeDirectoryConfiguration != null ? this.activeDirectoryConfiguration.toBuilder() : null;
        }

        public final void setActiveDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration.BuilderImpl activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration != null ? activeDirectoryConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder activeDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSvmAdminPassword() {
            return this.svmAdminPassword;
        }

        public final void setSvmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
        }

        @Override
        @Transient
        public final Builder svmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRootVolumeSecurityStyle() {
            return this.rootVolumeSecurityStyle;
        }

        public final void setRootVolumeSecurityStyle(String rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle = rootVolumeSecurityStyle;
        }

        @Override
        @Transient
        public final Builder rootVolumeSecurityStyle(String rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle = rootVolumeSecurityStyle;
            return this;
        }

        @Override
        @Transient
        public final Builder rootVolumeSecurityStyle(StorageVirtualMachineRootVolumeSecurityStyle rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle(rootVolumeSecurityStyle == null ? null : rootVolumeSecurityStyle.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStorageVirtualMachineRequest build() {
            return new CreateStorageVirtualMachineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStorageVirtualMachineRequest> {
        public Builder activeDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration var1);

        default public Builder activeDirectoryConfiguration(Consumer<CreateSvmActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
            return this.activeDirectoryConfiguration((CreateSvmActiveDirectoryConfiguration)((CreateSvmActiveDirectoryConfiguration.Builder)CreateSvmActiveDirectoryConfiguration.builder().applyMutation(activeDirectoryConfiguration)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder name(String var1);

        public Builder svmAdminPassword(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder rootVolumeSecurityStyle(String var1);

        public Builder rootVolumeSecurityStyle(StorageVirtualMachineRootVolumeSecurityStyle var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

