/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileSystemLifecycle {
    AVAILABLE("AVAILABLE"),
    CREATING("CREATING"),
    FAILED("FAILED"),
    DELETING("DELETING"),
    MISCONFIGURED("MISCONFIGURED"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileSystemLifecycle> VALUE_MAP;
    private final String value;

    private FileSystemLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileSystemLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileSystemLifecycle> knownValues() {
        EnumSet<FileSystemLifecycle> knownValues = EnumSet.allOf(FileSystemLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileSystemLifecycle.class, FileSystemLifecycle::toString);
    }
}

