/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreResponse;
import software.amazon.awssdk.services.fsx.model.DeleteFileSystemWindowsResponse;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.FileSystemLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFileSystemResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DeleteFileSystemResponse> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileSystemResponse.getter(DeleteFileSystemResponse::fileSystemId)).setter(DeleteFileSystemResponse.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileSystemResponse.getter(DeleteFileSystemResponse::lifecycleAsString)).setter(DeleteFileSystemResponse.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<DeleteFileSystemWindowsResponse> WINDOWS_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeleteFileSystemResponse.getter(DeleteFileSystemResponse::windowsResponse)).setter(DeleteFileSystemResponse.setter(Builder::windowsResponse)).constructor(DeleteFileSystemWindowsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsResponse").build()}).build();
    private static final SdkField<DeleteFileSystemLustreResponse> LUSTRE_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeleteFileSystemResponse.getter(DeleteFileSystemResponse::lustreResponse)).setter(DeleteFileSystemResponse.setter(Builder::lustreResponse)).constructor(DeleteFileSystemLustreResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, LIFECYCLE_FIELD, WINDOWS_RESPONSE_FIELD, LUSTRE_RESPONSE_FIELD));
    private final String fileSystemId;
    private final String lifecycle;
    private final DeleteFileSystemWindowsResponse windowsResponse;
    private final DeleteFileSystemLustreResponse lustreResponse;

    private DeleteFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.lifecycle = builder.lifecycle;
        this.windowsResponse = builder.windowsResponse;
        this.lustreResponse = builder.lustreResponse;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public FileSystemLifecycle lifecycle() {
        return FileSystemLifecycle.fromValue(this.lifecycle);
    }

    public String lifecycleAsString() {
        return this.lifecycle;
    }

    public DeleteFileSystemWindowsResponse windowsResponse() {
        return this.windowsResponse;
    }

    public DeleteFileSystemLustreResponse lustreResponse() {
        return this.lustreResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowsResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreResponse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemResponse)) {
            return false;
        }
        DeleteFileSystemResponse other = (DeleteFileSystemResponse)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.windowsResponse(), other.windowsResponse()) && Objects.equals(this.lustreResponse(), other.lustreResponse());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFileSystemResponse").add("FileSystemId", (Object)this.fileSystemId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("WindowsResponse", (Object)this.windowsResponse()).add("LustreResponse", (Object)this.lustreResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "WindowsResponse": {
                return Optional.ofNullable(clazz.cast(this.windowsResponse()));
            }
            case "LustreResponse": {
                return Optional.ofNullable(clazz.cast(this.lustreResponse()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemResponse, T> g) {
        return obj -> g.apply((DeleteFileSystemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String lifecycle;
        private DeleteFileSystemWindowsResponse windowsResponse;
        private DeleteFileSystemLustreResponse lustreResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemResponse model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.lifecycle(model.lifecycle);
            this.windowsResponse(model.windowsResponse);
            this.lustreResponse(model.lustreResponse);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(FileSystemLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        public final DeleteFileSystemWindowsResponse.Builder getWindowsResponse() {
            return this.windowsResponse != null ? this.windowsResponse.toBuilder() : null;
        }

        @Override
        public final Builder windowsResponse(DeleteFileSystemWindowsResponse windowsResponse) {
            this.windowsResponse = windowsResponse;
            return this;
        }

        public final void setWindowsResponse(DeleteFileSystemWindowsResponse.BuilderImpl windowsResponse) {
            this.windowsResponse = windowsResponse != null ? windowsResponse.build() : null;
        }

        public final DeleteFileSystemLustreResponse.Builder getLustreResponse() {
            return this.lustreResponse != null ? this.lustreResponse.toBuilder() : null;
        }

        @Override
        public final Builder lustreResponse(DeleteFileSystemLustreResponse lustreResponse) {
            this.lustreResponse = lustreResponse;
            return this;
        }

        public final void setLustreResponse(DeleteFileSystemLustreResponse.BuilderImpl lustreResponse) {
            this.lustreResponse = lustreResponse != null ? lustreResponse.build() : null;
        }

        @Override
        public DeleteFileSystemResponse build() {
            return new DeleteFileSystemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFileSystemResponse> {
        public Builder fileSystemId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(FileSystemLifecycle var1);

        public Builder windowsResponse(DeleteFileSystemWindowsResponse var1);

        default public Builder windowsResponse(Consumer<DeleteFileSystemWindowsResponse.Builder> windowsResponse) {
            return this.windowsResponse((DeleteFileSystemWindowsResponse)((DeleteFileSystemWindowsResponse.Builder)DeleteFileSystemWindowsResponse.builder().applyMutation(windowsResponse)).build());
        }

        public Builder lustreResponse(DeleteFileSystemLustreResponse var1);

        default public Builder lustreResponse(Consumer<DeleteFileSystemLustreResponse.Builder> lustreResponse) {
            return this.lustreResponse((DeleteFileSystemLustreResponse)((DeleteFileSystemLustreResponse.Builder)DeleteFileSystemLustreResponse.builder().applyMutation(lustreResponse)).build());
        }
    }
}

