/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting
 * AWS Support.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLimitExceededException extends FSxException implements
        ToCopyableBuilder<ServiceLimitExceededException.Builder, ServiceLimitExceededException> {
    private static final SdkField<String> LIMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceLimitExceededException::limitAsString)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String limit;

    private ServiceLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Enumeration of the service limit that was exceeded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limit} will return
     * {@link ServiceLimit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #limitAsString}.
     * </p>
     * 
     * @return Enumeration of the service limit that was exceeded.
     * @see ServiceLimit
     */
    public ServiceLimit limit() {
        return ServiceLimit.fromValue(limit);
    }

    /**
     * <p>
     * Enumeration of the service limit that was exceeded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limit} will return
     * {@link ServiceLimit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #limitAsString}.
     * </p>
     * 
     * @return Enumeration of the service limit that was exceeded.
     * @see ServiceLimit
     */
    public String limitAsString() {
        return limit;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLimitExceededException, T> g) {
        return obj -> g.apply((ServiceLimitExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLimitExceededException>, FSxException.Builder {
        /**
         * <p>
         * Enumeration of the service limit that was exceeded.
         * </p>
         * 
         * @param limit
         *        Enumeration of the service limit that was exceeded.
         * @see ServiceLimit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLimit
         */
        Builder limit(String limit);

        /**
         * <p>
         * Enumeration of the service limit that was exceeded.
         * </p>
         * 
         * @param limit
         *        Enumeration of the service limit that was exceeded.
         * @see ServiceLimit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLimit
         */
        Builder limit(ServiceLimit limit);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends FSxException.BuilderImpl implements Builder {
        private String limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLimitExceededException model) {
            super(model);
            limit(model.limit);
        }

        public final String getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public final Builder limit(ServiceLimit limit) {
            this.limit(limit == null ? null : limit.toString());
            return this;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ServiceLimitExceededException build() {
            return new ServiceLimitExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
