/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more network settings specified in the request are invalid. <code>InvalidVpcId</code> means that the ID passed
 * for the virtual private cloud (VPC) is invalid. <code>InvalidSubnetIds</code> returns the list of IDs for subnets
 * that are either invalid or not part of the VPC specified. <code>InvalidSecurityGroupIds</code> returns the list of
 * IDs for security groups that are either invalid or not part of the VPC specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidNetworkSettingsException extends FSxException implements
        ToCopyableBuilder<InvalidNetworkSettingsException.Builder, InvalidNetworkSettingsException> {
    private static final SdkField<String> INVALID_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvalidNetworkSettingsException::invalidSubnetId)).setter(setter(Builder::invalidSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidSubnetId").build()).build();

    private static final SdkField<String> INVALID_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvalidNetworkSettingsException::invalidSecurityGroupId))
            .setter(setter(Builder::invalidSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidSecurityGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_SUBNET_ID_FIELD,
            INVALID_SECURITY_GROUP_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String invalidSubnetId;

    private final String invalidSecurityGroupId;

    private InvalidNetworkSettingsException(BuilderImpl builder) {
        super(builder);
        this.invalidSubnetId = builder.invalidSubnetId;
        this.invalidSecurityGroupId = builder.invalidSecurityGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the InvalidSubnetId property for this object.
     * 
     * @return The value of the InvalidSubnetId property for this object.
     */
    public String invalidSubnetId() {
        return invalidSubnetId;
    }

    /**
     * Returns the value of the InvalidSecurityGroupId property for this object.
     * 
     * @return The value of the InvalidSecurityGroupId property for this object.
     */
    public String invalidSecurityGroupId() {
        return invalidSecurityGroupId;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidNetworkSettingsException, T> g) {
        return obj -> g.apply((InvalidNetworkSettingsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidNetworkSettingsException>, FSxException.Builder {
        /**
         * Sets the value of the InvalidSubnetId property for this object.
         *
         * @param invalidSubnetId
         *        The new value for the InvalidSubnetId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidSubnetId(String invalidSubnetId);

        /**
         * Sets the value of the InvalidSecurityGroupId property for this object.
         *
         * @param invalidSecurityGroupId
         *        The new value for the InvalidSecurityGroupId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidSecurityGroupId(String invalidSecurityGroupId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends FSxException.BuilderImpl implements Builder {
        private String invalidSubnetId;

        private String invalidSecurityGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidNetworkSettingsException model) {
            super(model);
            invalidSubnetId(model.invalidSubnetId);
            invalidSecurityGroupId(model.invalidSecurityGroupId);
        }

        public final String getInvalidSubnetId() {
            return invalidSubnetId;
        }

        @Override
        public final Builder invalidSubnetId(String invalidSubnetId) {
            this.invalidSubnetId = invalidSubnetId;
            return this;
        }

        public final void setInvalidSubnetId(String invalidSubnetId) {
            this.invalidSubnetId = invalidSubnetId;
        }

        public final String getInvalidSecurityGroupId() {
            return invalidSecurityGroupId;
        }

        @Override
        public final Builder invalidSecurityGroupId(String invalidSecurityGroupId) {
            this.invalidSecurityGroupId = invalidSecurityGroupId;
            return this;
        }

        public final void setInvalidSecurityGroupId(String invalidSecurityGroupId) {
            this.invalidSecurityGroupId = invalidSecurityGroupId;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidNetworkSettingsException build() {
            return new InvalidNetworkSettingsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
