/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileSystemWindowsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteFileSystemWindowsConfiguration.Builder, DeleteFileSystemWindowsConfiguration> {
    private static final SdkField<Boolean> SKIP_FINAL_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteFileSystemWindowsConfiguration::skipFinalBackup)).setter(setter(Builder::skipFinalBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalBackup").build()).build();

    private static final SdkField<List<Tag>> FINAL_BACKUP_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DeleteFileSystemWindowsConfiguration::finalBackupTags))
            .setter(setter(Builder::finalBackupTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKIP_FINAL_BACKUP_FIELD,
            FINAL_BACKUP_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean skipFinalBackup;

    private final List<Tag> finalBackupTags;

    private DeleteFileSystemWindowsConfiguration(BuilderImpl builder) {
        this.skipFinalBackup = builder.skipFinalBackup;
        this.finalBackupTags = builder.finalBackupTags;
    }

    /**
     * <p>
     * By default, Amazon FSx for Windows takes a final backup on your behalf when the <code>DeleteFileSystem</code>
     * operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final
     * backup. If you want to skip this backup, use this flag to do so.
     * </p>
     * 
     * @return By default, Amazon FSx for Windows takes a final backup on your behalf when the
     *         <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you from data loss, and we
     *         highly recommend taking the final backup. If you want to skip this backup, use this flag to do so.
     */
    public Boolean skipFinalBackup() {
        return skipFinalBackup;
    }

    /**
     * Returns true if the FinalBackupTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFinalBackupTags() {
        return finalBackupTags != null && !(finalBackupTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of tags for your final backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFinalBackupTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of tags for your final backup.
     */
    public List<Tag> finalBackupTags() {
        return finalBackupTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalBackup());
        hashCode = 31 * hashCode + Objects.hashCode(finalBackupTags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemWindowsConfiguration)) {
            return false;
        }
        DeleteFileSystemWindowsConfiguration other = (DeleteFileSystemWindowsConfiguration) obj;
        return Objects.equals(skipFinalBackup(), other.skipFinalBackup())
                && Objects.equals(finalBackupTags(), other.finalBackupTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteFileSystemWindowsConfiguration").add("SkipFinalBackup", skipFinalBackup())
                .add("FinalBackupTags", finalBackupTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkipFinalBackup":
            return Optional.ofNullable(clazz.cast(skipFinalBackup()));
        case "FinalBackupTags":
            return Optional.ofNullable(clazz.cast(finalBackupTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemWindowsConfiguration, T> g) {
        return obj -> g.apply((DeleteFileSystemWindowsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteFileSystemWindowsConfiguration> {
        /**
         * <p>
         * By default, Amazon FSx for Windows takes a final backup on your behalf when the <code>DeleteFileSystem</code>
         * operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final
         * backup. If you want to skip this backup, use this flag to do so.
         * </p>
         * 
         * @param skipFinalBackup
         *        By default, Amazon FSx for Windows takes a final backup on your behalf when the
         *        <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you from data loss, and
         *        we highly recommend taking the final backup. If you want to skip this backup, use this flag to do so.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalBackup(Boolean skipFinalBackup);

        /**
         * <p>
         * A set of tags for your final backup.
         * </p>
         * 
         * @param finalBackupTags
         *        A set of tags for your final backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Collection<Tag> finalBackupTags);

        /**
         * <p>
         * A set of tags for your final backup.
         * </p>
         * 
         * @param finalBackupTags
         *        A set of tags for your final backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Tag... finalBackupTags);

        /**
         * <p>
         * A set of tags for your final backup.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #finalBackupTags(List<Tag>)}.
         * 
         * @param finalBackupTags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalBackupTags(List<Tag>)
         */
        Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags);
    }

    static final class BuilderImpl implements Builder {
        private Boolean skipFinalBackup;

        private List<Tag> finalBackupTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemWindowsConfiguration model) {
            skipFinalBackup(model.skipFinalBackup);
            finalBackupTags(model.finalBackupTags);
        }

        public final Boolean getSkipFinalBackup() {
            return skipFinalBackup;
        }

        @Override
        public final Builder skipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
            return this;
        }

        public final void setSkipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
        }

        public final Collection<Tag.Builder> getFinalBackupTags() {
            return finalBackupTags != null ? finalBackupTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder finalBackupTags(Collection<Tag> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copy(finalBackupTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Tag... finalBackupTags) {
            finalBackupTags(Arrays.asList(finalBackupTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags) {
            finalBackupTags(Stream.of(finalBackupTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFinalBackupTags(Collection<Tag.BuilderImpl> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copyFromBuilder(finalBackupTags);
        }

        @Override
        public DeleteFileSystemWindowsConfiguration build() {
            return new DeleteFileSystemWindowsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
