/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data repository configuration object for Lustre file systems returned in the response of the
 * <code>CreateFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataRepositoryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataRepositoryConfiguration.Builder, DataRepositoryConfiguration> {
    private static final SdkField<String> IMPORT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataRepositoryConfiguration::importPath)).setter(setter(Builder::importPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportPath").build()).build();

    private static final SdkField<String> EXPORT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataRepositoryConfiguration::exportPath)).setter(setter(Builder::exportPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportPath").build()).build();

    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DataRepositoryConfiguration::importedFileChunkSize)).setter(setter(Builder::importedFileChunkSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_PATH_FIELD,
            EXPORT_PATH_FIELD, IMPORTED_FILE_CHUNK_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String importPath;

    private final String exportPath;

    private final Integer importedFileChunkSize;

    private DataRepositoryConfiguration(BuilderImpl builder) {
        this.importPath = builder.importPath;
        this.exportPath = builder.exportPath;
        this.importedFileChunkSize = builder.importedFileChunkSize;
    }

    /**
     * <p>
     * The import path to the Amazon S3 bucket (and optional prefix) that you're using as the data repository for your
     * FSx for Lustre file system, for example <code>s3://import-bucket/optional-prefix</code>. If a prefix is specified
     * after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
     * </p>
     * 
     * @return The import path to the Amazon S3 bucket (and optional prefix) that you're using as the data repository
     *         for your FSx for Lustre file system, for example <code>s3://import-bucket/optional-prefix</code>. If a
     *         prefix is specified after the Amazon S3 bucket name, only object keys with that prefix are loaded into
     *         the file system.
     */
    public String importPath() {
        return importPath;
    }

    /**
     * <p>
     * The export path to the Amazon S3 bucket (and prefix) that you are using to store new and changed Lustre file
     * system files in S3.
     * </p>
     * 
     * @return The export path to the Amazon S3 bucket (and prefix) that you are using to store new and changed Lustre
     *         file system files in S3.
     */
    public String exportPath() {
        return exportPath;
    }

    /**
     * <p>
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per
     * file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped
     * across is limited by the total number of disks that make up the file system.
     * </p>
     * <p>
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a
     * maximum size of 5 TB.
     * </p>
     * 
     * @return For files imported from a data repository, this value determines the stripe count and maximum amount of
     *         data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file
     *         can be striped across is limited by the total number of disks that make up the file system.</p>
     *         <p>
     *         The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
     *         objects have a maximum size of 5 TB.
     */
    public Integer importedFileChunkSize() {
        return importedFileChunkSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importPath());
        hashCode = 31 * hashCode + Objects.hashCode(exportPath());
        hashCode = 31 * hashCode + Objects.hashCode(importedFileChunkSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRepositoryConfiguration)) {
            return false;
        }
        DataRepositoryConfiguration other = (DataRepositoryConfiguration) obj;
        return Objects.equals(importPath(), other.importPath()) && Objects.equals(exportPath(), other.exportPath())
                && Objects.equals(importedFileChunkSize(), other.importedFileChunkSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataRepositoryConfiguration").add("ImportPath", importPath()).add("ExportPath", exportPath())
                .add("ImportedFileChunkSize", importedFileChunkSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportPath":
            return Optional.ofNullable(clazz.cast(importPath()));
        case "ExportPath":
            return Optional.ofNullable(clazz.cast(exportPath()));
        case "ImportedFileChunkSize":
            return Optional.ofNullable(clazz.cast(importedFileChunkSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataRepositoryConfiguration, T> g) {
        return obj -> g.apply((DataRepositoryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataRepositoryConfiguration> {
        /**
         * <p>
         * The import path to the Amazon S3 bucket (and optional prefix) that you're using as the data repository for
         * your FSx for Lustre file system, for example <code>s3://import-bucket/optional-prefix</code>. If a prefix is
         * specified after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
         * </p>
         * 
         * @param importPath
         *        The import path to the Amazon S3 bucket (and optional prefix) that you're using as the data repository
         *        for your FSx for Lustre file system, for example <code>s3://import-bucket/optional-prefix</code>. If a
         *        prefix is specified after the Amazon S3 bucket name, only object keys with that prefix are loaded into
         *        the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importPath(String importPath);

        /**
         * <p>
         * The export path to the Amazon S3 bucket (and prefix) that you are using to store new and changed Lustre file
         * system files in S3.
         * </p>
         * 
         * @param exportPath
         *        The export path to the Amazon S3 bucket (and prefix) that you are using to store new and changed
         *        Lustre file system files in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportPath(String exportPath);

        /**
         * <p>
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data
         * per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be
         * striped across is limited by the total number of disks that make up the file system.
         * </p>
         * <p>
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects
         * have a maximum size of 5 TB.
         * </p>
         * 
         * @param importedFileChunkSize
         *        For files imported from a data repository, this value determines the stripe count and maximum amount
         *        of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single
         *        file can be striped across is limited by the total number of disks that make up the file system.</p>
         *        <p>
         *        The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
         *        objects have a maximum size of 5 TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedFileChunkSize(Integer importedFileChunkSize);
    }

    static final class BuilderImpl implements Builder {
        private String importPath;

        private String exportPath;

        private Integer importedFileChunkSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRepositoryConfiguration model) {
            importPath(model.importPath);
            exportPath(model.exportPath);
            importedFileChunkSize(model.importedFileChunkSize);
        }

        public final String getImportPath() {
            return importPath;
        }

        @Override
        public final Builder importPath(String importPath) {
            this.importPath = importPath;
            return this;
        }

        public final void setImportPath(String importPath) {
            this.importPath = importPath;
        }

        public final String getExportPath() {
            return exportPath;
        }

        @Override
        public final Builder exportPath(String exportPath) {
            this.exportPath = exportPath;
            return this;
        }

        public final void setExportPath(String exportPath) {
            this.exportPath = exportPath;
        }

        public final Integer getImportedFileChunkSize() {
            return importedFileChunkSize;
        }

        @Override
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        @Override
        public DataRepositoryConfiguration build() {
            return new DataRepositoryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
