/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Lustre configuration for the file system being created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemLustreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFileSystemLustreConfiguration.Builder, CreateFileSystemLustreConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemLustreConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<String> IMPORT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemLustreConfiguration::importPath)).setter(setter(Builder::importPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportPath").build()).build();

    private static final SdkField<String> EXPORT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemLustreConfiguration::exportPath)).setter(setter(Builder::exportPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportPath").build()).build();

    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateFileSystemLustreConfiguration::importedFileChunkSize))
            .setter(setter(Builder::importedFileChunkSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemLustreConfiguration::deploymentTypeAsString)).setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateFileSystemLustreConfiguration::perUnitStorageThroughput))
            .setter(setter(Builder::perUnitStorageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEEKLY_MAINTENANCE_START_TIME_FIELD, IMPORT_PATH_FIELD, EXPORT_PATH_FIELD, IMPORTED_FILE_CHUNK_SIZE_FIELD,
            DEPLOYMENT_TYPE_FIELD, PER_UNIT_STORAGE_THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String weeklyMaintenanceStartTime;

    private final String importPath;

    private final String exportPath;

    private final Integer importedFileChunkSize;

    private final String deploymentType;

    private final Integer perUnitStorageThroughput;

    private CreateFileSystemLustreConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.importPath = builder.importPath;
        this.exportPath = builder.exportPath;
        this.importedFileChunkSize = builder.importedFileChunkSize;
        this.deploymentType = builder.deploymentType;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
    }

    /**
     * <p>
     * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the
     * weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     * </p>
     * 
     * @return The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d
     *         is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data
     * repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will be mapped
     * to the root of the Amazon S3 bucket you select. An example is <code>s3://import-bucket/optional-prefix</code>. If
     * you specify a prefix after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file
     * system.
     * </p>
     * 
     * @return (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data
     *         repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will
     *         be mapped to the root of the Amazon S3 bucket you select. An example is
     *         <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix after the Amazon S3 bucket name,
     *         only object keys with that prefix are loaded into the file system.
     */
    public String importPath() {
        return importPath;
    }

    /**
     * <p>
     * (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path must use the
     * same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and changed
     * data is to be exported from your Amazon FSx for Lustre file system. If an <code>ExportPath</code> value is not
     * provided, Amazon FSx sets a default export path, <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>.
     * The timestamp is in UTC format, for example <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.
     * </p>
     * <p>
     * The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>. If you
     * only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of file system objects
     * to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you provide a
     * custom prefix in the export path, such as <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx
     * exports the contents of your file system to that export prefix in the Amazon S3 bucket.
     * </p>
     * 
     * @return (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path must
     *         use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new
     *         and changed data is to be exported from your Amazon FSx for Lustre file system. If an
     *         <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
     *         <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in UTC format, for
     *         example <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
     *         <p>
     *         The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>.
     *         If you only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of file
     *         system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on
     *         export. If you provide a custom prefix in the export path, such as
     *         <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
     *         system to that export prefix in the Amazon S3 bucket.
     */
    public String exportPath() {
        return exportPath;
    }

    /**
     * <p>
     * (Optional) For files imported from a data repository, this value determines the stripe count and maximum amount
     * of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be
     * striped across is limited by the total number of disks that make up the file system.
     * </p>
     * <p>
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a
     * maximum size of 5 TB.
     * </p>
     * 
     * @return (Optional) For files imported from a data repository, this value determines the stripe count and maximum
     *         amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a
     *         single file can be striped across is limited by the total number of disks that make up the file
     *         system.</p>
     *         <p>
     *         The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
     *         objects have a maximum size of 5 TB.
     */
    public Integer importedFileChunkSize() {
        return importedFileChunkSize;
    }

    /**
     * <p>
     * (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary
     * storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit
     * encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.
     * </p>
     * <p>
     * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data in
     * transit. To learn more about deployment types, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre Deployment
     * Options</a>.
     * </p>
     * <p>
     * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
     * (Default = <code>SCRATCH_1</code>)
     * </p>
     * <p>
     * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
     * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
     * Transit</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link LustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need
     *         temporary storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type
     *         provides in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>
     *         .</p>
     *         <p>
     *         Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of
     *         data in transit. To learn more about deployment types, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
     *         Deployment Options</a>.
     *         </p>
     *         <p>
     *         Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     *         <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
     *         feature</a>. (Default = <code>SCRATCH_1</code>)
     *         </p>
     *         <p>
     *         Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types
     *         is supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data
     *         in Transit</a>.
     * @see LustreDeploymentType
     */
    public LustreDeploymentType deploymentType() {
        return LustreDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary
     * storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit
     * encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.
     * </p>
     * <p>
     * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data in
     * transit. To learn more about deployment types, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre Deployment
     * Options</a>.
     * </p>
     * <p>
     * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
     * (Default = <code>SCRATCH_1</code>)
     * </p>
     * <p>
     * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
     * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
     * Transit</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link LustreDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need
     *         temporary storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type
     *         provides in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>
     *         .</p>
     *         <p>
     *         Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of
     *         data in transit. To learn more about deployment types, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
     *         Deployment Options</a>.
     *         </p>
     *         <p>
     *         Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
     *         <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
     *         feature</a>. (Default = <code>SCRATCH_1</code>)
     *         </p>
     *         <p>
     *         Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types
     *         is supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
     *         href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data
     *         in Transit</a>.
     * @see LustreDeploymentType
     */
    public String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write throughput for
     * each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated by multiplying ﬁle system
     * storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB ﬁle system, provisioning 50
     * MB/s/TiB of PerUnitStorageThroughput yields 117 MB/s of ﬁle system throughput. You pay for the amount of
     * throughput that you provision.
     * </p>
     * <p>
     * Valid values are 50, 100, 200.
     * </p>
     * 
     * @return Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
     *         throughput for each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated by
     *         multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB
     *         ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 117 MB/s of ﬁle system
     *         throughput. You pay for the amount of throughput that you provision. </p>
     *         <p>
     *         Valid values are 50, 100, 200.
     */
    public Integer perUnitStorageThroughput() {
        return perUnitStorageThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(importPath());
        hashCode = 31 * hashCode + Objects.hashCode(exportPath());
        hashCode = 31 * hashCode + Objects.hashCode(importedFileChunkSize());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(perUnitStorageThroughput());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemLustreConfiguration)) {
            return false;
        }
        CreateFileSystemLustreConfiguration other = (CreateFileSystemLustreConfiguration) obj;
        return Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(importPath(), other.importPath()) && Objects.equals(exportPath(), other.exportPath())
                && Objects.equals(importedFileChunkSize(), other.importedFileChunkSize())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(perUnitStorageThroughput(), other.perUnitStorageThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFileSystemLustreConfiguration")
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime()).add("ImportPath", importPath())
                .add("ExportPath", exportPath()).add("ImportedFileChunkSize", importedFileChunkSize())
                .add("DeploymentType", deploymentTypeAsString()).add("PerUnitStorageThroughput", perUnitStorageThroughput())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "ImportPath":
            return Optional.ofNullable(clazz.cast(importPath()));
        case "ExportPath":
            return Optional.ofNullable(clazz.cast(exportPath()));
        case "ImportedFileChunkSize":
            return Optional.ofNullable(clazz.cast(importedFileChunkSize()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "PerUnitStorageThroughput":
            return Optional.ofNullable(clazz.cast(perUnitStorageThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemLustreConfiguration, T> g) {
        return obj -> g.apply((CreateFileSystemLustreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFileSystemLustreConfiguration> {
        /**
         * <p>
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is
         * the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * </p>
         * 
         * @param weeklyMaintenanceStartTime
         *        The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where
         *        d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data
         * repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will be
         * mapped to the root of the Amazon S3 bucket you select. An example is
         * <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix after the Amazon S3 bucket name,
         * only object keys with that prefix are loaded into the file system.
         * </p>
         * 
         * @param importPath
         *        (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the
         *        data repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file
         *        system will be mapped to the root of the Amazon S3 bucket you select. An example is
         *        <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix after the Amazon S3 bucket
         *        name, only object keys with that prefix are loaded into the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importPath(String importPath);

        /**
         * <p>
         * (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path must use
         * the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and
         * changed data is to be exported from your Amazon FSx for Lustre file system. If an <code>ExportPath</code>
         * value is not provided, Amazon FSx sets a default export path,
         * <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in UTC format, for example
         * <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.
         * </p>
         * <p>
         * The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>. If
         * you only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of file system
         * objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you
         * provide a custom prefix in the export path, such as <code>s3://import-bucket/[custom-optional-prefix]</code>,
         * Amazon FSx exports the contents of your file system to that export prefix in the Amazon S3 bucket.
         * </p>
         * 
         * @param exportPath
         *        (Optional) The path in Amazon S3 where the root of your Amazon FSx file system is exported. The path
         *        must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to
         *        which new and changed data is to be exported from your Amazon FSx for Lustre file system. If an
         *        <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path,
         *        <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in UTC format, for
         *        example <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p>
         *        <p>
         *        The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>
         *        . If you only specify a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of
         *        file system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten
         *        on export. If you provide a custom prefix in the export path, such as
         *        <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file
         *        system to that export prefix in the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportPath(String exportPath);

        /**
         * <p>
         * (Optional) For files imported from a data repository, this value determines the stripe count and maximum
         * amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single
         * file can be striped across is limited by the total number of disks that make up the file system.
         * </p>
         * <p>
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects
         * have a maximum size of 5 TB.
         * </p>
         * 
         * @param importedFileChunkSize
         *        (Optional) For files imported from a data repository, this value determines the stripe count and
         *        maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks
         *        that a single file can be striped across is limited by the total number of disks that make up the file
         *        system.</p>
         *        <p>
         *        The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3
         *        objects have a maximum size of 5 TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedFileChunkSize(Integer importedFileChunkSize);

        /**
         * <p>
         * (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary
         * storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit
         * encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.
         * </p>
         * <p>
         * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data
         * in transit. To learn more about deployment types, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         * Deployment Options</a>.
         * </p>
         * <p>
         * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
         * (Default = <code>SCRATCH_1</code>)
         * </p>
         * <p>
         * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
         * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
         * Transit</a>.
         * </p>
         * 
         * @param deploymentType
         *        (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need
         *        temporary storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type
         *        provides in-transit encryption of data and higher burst throughput capacity than
         *        <code>SCRATCH_1</code>.</p>
         *        <p>
         *        Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption
         *        of data in transit. To learn more about deployment types, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         *        Deployment Options</a>.
         *        </p>
         *        <p>
         *        Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         *        <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
         *        feature</a>. (Default = <code>SCRATCH_1</code>)
         *        </p>
         *        <p>
         *        Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment
         *        types is supported when accessed from supported instance types in supported AWS Regions. To learn
         *        more, <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting
         *        Data in Transit</a>.
         * @see LustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary
         * storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit
         * encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.
         * </p>
         * <p>
         * Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption of data
         * in transit. To learn more about deployment types, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         * Deployment Options</a>.
         * </p>
         * <p>
         * Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         * <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this feature</a>.
         * (Default = <code>SCRATCH_1</code>)
         * </p>
         * <p>
         * Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment types is
         * supported when accessed from supported instance types in supported AWS Regions. To learn more, <a
         * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting Data in
         * Transit</a>.
         * </p>
         * 
         * @param deploymentType
         *        (Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need
         *        temporary storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type
         *        provides in-transit encryption of data and higher burst throughput capacity than
         *        <code>SCRATCH_1</code>.</p>
         *        <p>
         *        Choose <code>PERSISTENT_1</code> deployment type for longer-term storage and workloads and encryption
         *        of data in transit. To learn more about deployment types, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre
         *        Deployment Options</a>.
         *        </p>
         *        <p>
         *        Encryption of data in-transit is automatically enabled when you access a <code>SCRATCH_2</code> or
         *        <code>PERSISTENT_1</code> file system from Amazon EC2 instances that <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support this
         *        feature</a>. (Default = <code>SCRATCH_1</code>)
         *        </p>
         *        <p>
         *        Encryption of data in-transit for <code>SCRATCH_2</code> and <code>PERSISTENT_1</code> deployment
         *        types is supported when accessed from supported instance types in supported AWS Regions. To learn
         *        more, <a
         *        href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting
         *        Data in Transit</a>.
         * @see LustreDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LustreDeploymentType
         */
        Builder deploymentType(LustreDeploymentType deploymentType);

        /**
         * <p>
         * Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write throughput
         * for each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated by multiplying ﬁle
         * system storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB ﬁle system,
         * provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 117 MB/s of ﬁle system throughput. You pay for
         * the amount of throughput that you provision.
         * </p>
         * <p>
         * Valid values are 50, 100, 200.
         * </p>
         * 
         * @param perUnitStorageThroughput
         *        Required for the <code>PERSISTENT_1</code> deployment type, describes the amount of read and write
         *        throughput for each 1 tebibyte of storage, in MB/s/TiB. File system throughput capacity is calculated
         *        by multiplying ﬁle system storage capacity (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4
         *        TiB ﬁle system, provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 117 MB/s of ﬁle system
         *        throughput. You pay for the amount of throughput that you provision. </p>
         *        <p>
         *        Valid values are 50, 100, 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perUnitStorageThroughput(Integer perUnitStorageThroughput);
    }

    static final class BuilderImpl implements Builder {
        private String weeklyMaintenanceStartTime;

        private String importPath;

        private String exportPath;

        private Integer importedFileChunkSize;

        private String deploymentType;

        private Integer perUnitStorageThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemLustreConfiguration model) {
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            importPath(model.importPath);
            exportPath(model.exportPath);
            importedFileChunkSize(model.importedFileChunkSize);
            deploymentType(model.deploymentType);
            perUnitStorageThroughput(model.perUnitStorageThroughput);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final String getImportPath() {
            return importPath;
        }

        @Override
        public final Builder importPath(String importPath) {
            this.importPath = importPath;
            return this;
        }

        public final void setImportPath(String importPath) {
            this.importPath = importPath;
        }

        public final String getExportPath() {
            return exportPath;
        }

        @Override
        public final Builder exportPath(String exportPath) {
            this.exportPath = exportPath;
            return this;
        }

        public final void setExportPath(String exportPath) {
            this.exportPath = exportPath;
        }

        public final Integer getImportedFileChunkSize() {
            return importedFileChunkSize;
        }

        @Override
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(LustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final Integer getPerUnitStorageThroughput() {
            return perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        public CreateFileSystemLustreConfiguration build() {
            return new CreateFileSystemLustreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
