/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The type of error relating to Microsoft Active Directory. NOT_FOUND means that no directory was found by specifying
 * the given directory. INCOMPATIBLE_MODE means that the directory specified is not a Microsoft AD directory. WRONG_VPC
 * means that the specified directory isn't accessible from the specified VPC. WRONG_STAGE means that the specified
 * directory isn't currently in the ACTIVE state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum ActiveDirectoryErrorType {
    DOMAIN_NOT_FOUND("DOMAIN_NOT_FOUND"),

    INCOMPATIBLE_DOMAIN_MODE("INCOMPATIBLE_DOMAIN_MODE"),

    WRONG_VPC("WRONG_VPC"),

    INVALID_DOMAIN_STAGE("INVALID_DOMAIN_STAGE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActiveDirectoryErrorType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ActiveDirectoryErrorType corresponding to the value
     */
    public static ActiveDirectoryErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActiveDirectoryErrorType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ActiveDirectoryErrorType}s
     */
    public static Set<ActiveDirectoryErrorType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
