/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the Amazon FSx for Lustre file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LustreFileSystemConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LustreFileSystemConfiguration.Builder, LustreFileSystemConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LustreFileSystemConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<DataRepositoryConfiguration> DATA_REPOSITORY_CONFIGURATION_FIELD = SdkField
            .<DataRepositoryConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(LustreFileSystemConfiguration::dataRepositoryConfiguration))
            .setter(setter(Builder::dataRepositoryConfiguration))
            .constructor(DataRepositoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEEKLY_MAINTENANCE_START_TIME_FIELD, DATA_REPOSITORY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String weeklyMaintenanceStartTime;

    private final DataRepositoryConfiguration dataRepositoryConfiguration;

    private LustreFileSystemConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dataRepositoryConfiguration = builder.dataRepositoryConfiguration;
    }

    /**
     * <p>
     * The UTC time that you want to begin your weekly maintenance window.
     * </p>
     * 
     * @return The UTC time that you want to begin your weekly maintenance window.
     */
    public String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * Returns the value of the DataRepositoryConfiguration property for this object.
     * 
     * @return The value of the DataRepositoryConfiguration property for this object.
     */
    public DataRepositoryConfiguration dataRepositoryConfiguration() {
        return dataRepositoryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataRepositoryConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LustreFileSystemConfiguration)) {
            return false;
        }
        LustreFileSystemConfiguration other = (LustreFileSystemConfiguration) obj;
        return Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(dataRepositoryConfiguration(), other.dataRepositoryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LustreFileSystemConfiguration").add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DataRepositoryConfiguration", dataRepositoryConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DataRepositoryConfiguration":
            return Optional.ofNullable(clazz.cast(dataRepositoryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LustreFileSystemConfiguration, T> g) {
        return obj -> g.apply((LustreFileSystemConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LustreFileSystemConfiguration> {
        /**
         * <p>
         * The UTC time that you want to begin your weekly maintenance window.
         * </p>
         * 
         * @param weeklyMaintenanceStartTime
         *        The UTC time that you want to begin your weekly maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * Sets the value of the DataRepositoryConfiguration property for this object.
         *
         * @param dataRepositoryConfiguration
         *        The new value for the DataRepositoryConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRepositoryConfiguration(DataRepositoryConfiguration dataRepositoryConfiguration);

        /**
         * Sets the value of the DataRepositoryConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataRepositoryConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataRepositoryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataRepositoryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataRepositoryConfiguration(DataRepositoryConfiguration)}.
         * 
         * @param dataRepositoryConfiguration
         *        a consumer that will call methods on {@link DataRepositoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataRepositoryConfiguration(DataRepositoryConfiguration)
         */
        default Builder dataRepositoryConfiguration(Consumer<DataRepositoryConfiguration.Builder> dataRepositoryConfiguration) {
            return dataRepositoryConfiguration(DataRepositoryConfiguration.builder().applyMutation(dataRepositoryConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String weeklyMaintenanceStartTime;

        private DataRepositoryConfiguration dataRepositoryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LustreFileSystemConfiguration model) {
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            dataRepositoryConfiguration(model.dataRepositoryConfiguration);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final DataRepositoryConfiguration.Builder getDataRepositoryConfiguration() {
            return dataRepositoryConfiguration != null ? dataRepositoryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dataRepositoryConfiguration(DataRepositoryConfiguration dataRepositoryConfiguration) {
            this.dataRepositoryConfiguration = dataRepositoryConfiguration;
            return this;
        }

        public final void setDataRepositoryConfiguration(DataRepositoryConfiguration.BuilderImpl dataRepositoryConfiguration) {
            this.dataRepositoryConfiguration = dataRepositoryConfiguration != null ? dataRepositoryConfiguration.build() : null;
        }

        @Override
        public LustreFileSystemConfiguration build() {
            return new LustreFileSystemConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
