/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error returned when a second request is received with the same client request token but different parameters
 * settings. A client request token should always uniquely identify a single request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncompatibleParameterErrorException extends FSxException implements
        ToCopyableBuilder<IncompatibleParameterErrorException.Builder, IncompatibleParameterErrorException> {
    private static final SdkField<String> PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IncompatibleParameterErrorException::parameter)).setter(setter(Builder::parameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameter;

    private IncompatibleParameterErrorException(BuilderImpl builder) {
        super(builder);
        this.parameter = builder.parameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * A parameter that is incompatible with the earlier request.
     * </p>
     * 
     * @return A parameter that is incompatible with the earlier request.
     */
    public String parameter() {
        return parameter;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncompatibleParameterErrorException, T> g) {
        return obj -> g.apply((IncompatibleParameterErrorException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncompatibleParameterErrorException>, FSxException.Builder {
        /**
         * <p>
         * A parameter that is incompatible with the earlier request.
         * </p>
         * 
         * @param parameter
         *        A parameter that is incompatible with the earlier request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameter(String parameter);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends FSxException.BuilderImpl implements Builder {
        private String parameter;

        private BuilderImpl() {
        }

        private BuilderImpl(IncompatibleParameterErrorException model) {
            super(model);
            parameter(model.parameter);
        }

        public final String getParameter() {
            return parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public IncompatibleParameterErrorException build() {
            return new IncompatibleParameterErrorException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
