/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (Optional) An array of filter objects you can use to filter the response of data repository tasks you will see in the
 * the response. You can filter the tasks returned in the response by one or more file system IDs, task lifecycles, and
 * by task type. A filter object consists of a filter <code>Name</code>, and one or more <code>Values</code> for the
 * filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataRepositoryTaskFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DataRepositoryTaskFilter.Builder, DataRepositoryTaskFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataRepositoryTaskFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DataRepositoryTaskFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private DataRepositoryTaskFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
    }

    /**
     * <p>
     * Name of the task property to use in filtering the tasks returned in the response.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states, as
     * follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DataRepositoryTaskFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the task property to use in filtering the tasks returned in the response.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle
     *         states, as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
     *         </p>
     *         </li>
     * @see DataRepositoryTaskFilterName
     */
    public DataRepositoryTaskFilterName name() {
        return DataRepositoryTaskFilterName.fromValue(name);
    }

    /**
     * <p>
     * Name of the task property to use in filtering the tasks returned in the response.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states, as
     * follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DataRepositoryTaskFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the task property to use in filtering the tasks returned in the response.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle
     *         states, as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
     *         </p>
     *         </li>
     * @see DataRepositoryTaskFilterName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use Values to include the specific file system IDs and task lifecycle states for the filters you are using.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Use Values to include the specific file system IDs and task lifecycle states for the filters you are
     *         using.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRepositoryTaskFilter)) {
            return false;
        }
        DataRepositoryTaskFilter other = (DataRepositoryTaskFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataRepositoryTaskFilter").add("Name", nameAsString()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataRepositoryTaskFilter, T> g) {
        return obj -> g.apply((DataRepositoryTaskFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataRepositoryTaskFilter> {
        /**
         * <p>
         * Name of the task property to use in filtering the tasks returned in the response.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states,
         * as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Name of the task property to use in filtering the tasks returned in the response.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle
         *        states, as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
         *        </p>
         *        </li>
         * @see DataRepositoryTaskFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryTaskFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * Name of the task property to use in filtering the tasks returned in the response.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states,
         * as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Name of the task property to use in filtering the tasks returned in the response.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle
         *        states, as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.
         *        </p>
         *        </li>
         * @see DataRepositoryTaskFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryTaskFilterName
         */
        Builder name(DataRepositoryTaskFilterName name);

        /**
         * <p>
         * Use Values to include the specific file system IDs and task lifecycle states for the filters you are using.
         * </p>
         * 
         * @param values
         *        Use Values to include the specific file system IDs and task lifecycle states for the filters you are
         *        using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * Use Values to include the specific file system IDs and task lifecycle states for the filters you are using.
         * </p>
         * 
         * @param values
         *        Use Values to include the specific file system IDs and task lifecycle states for the filters you are
         *        using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataRepositoryTaskFilter model) {
            name(model.name);
            values(model.values);
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DataRepositoryTaskFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = DataRepositoryTaskFilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = DataRepositoryTaskFilterValuesCopier.copy(values);
        }

        @Override
        public DataRepositoryTaskFilter build() {
            return new DataRepositoryTaskFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
