/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration object for the Microsoft Windows file system used in <code>CreateFileSystem</code> and
 * <code>CreateFileSystemFromBackup</code> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemWindowsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFileSystemWindowsConfiguration.Builder, CreateFileSystemWindowsConfiguration> {
    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemWindowsConfiguration::activeDirectoryId)).setter(setter(Builder::activeDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()).build();

    private static final SdkField<SelfManagedActiveDirectoryConfiguration> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<SelfManagedActiveDirectoryConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFileSystemWindowsConfiguration::selfManagedActiveDirectoryConfiguration))
            .setter(setter(Builder::selfManagedActiveDirectoryConfiguration))
            .constructor(SelfManagedActiveDirectoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SelfManagedActiveDirectoryConfiguration").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemWindowsConfiguration::deploymentTypeAsString)).setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<String> PREFERRED_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemWindowsConfiguration::preferredSubnetId)).setter(setter(Builder::preferredSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredSubnetId").build()).build();

    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateFileSystemWindowsConfiguration::throughputCapacity)).setter(setter(Builder::throughputCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemWindowsConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemWindowsConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateFileSystemWindowsConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateFileSystemWindowsConfiguration::copyTagsToBackups)).setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_ID_FIELD,
            SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD, DEPLOYMENT_TYPE_FIELD, PREFERRED_SUBNET_ID_FIELD,
            THROUGHPUT_CAPACITY_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD,
            AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeDirectoryId;

    private final SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration;

    private final String deploymentType;

    private final String preferredSubnetId;

    private final Integer throughputCapacity;

    private final String weeklyMaintenanceStartTime;

    private final String dailyAutomaticBackupStartTime;

    private final Integer automaticBackupRetentionDays;

    private final Boolean copyTagsToBackups;

    private CreateFileSystemWindowsConfiguration(BuilderImpl builder) {
        this.activeDirectoryId = builder.activeDirectoryId;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
        this.deploymentType = builder.deploymentType;
        this.preferredSubnetId = builder.preferredSubnetId;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
    }

    /**
     * <p>
     * The ID for an existing AWS Managed Microsoft Active Directory (AD) instance that the file system should join when
     * it's created.
     * </p>
     * 
     * @return The ID for an existing AWS Managed Microsoft Active Directory (AD) instance that the file system should
     *         join when it's created.
     */
    public String activeDirectoryId() {
        return activeDirectoryId;
    }

    /**
     * Returns the value of the SelfManagedActiveDirectoryConfiguration property for this object.
     * 
     * @return The value of the SelfManagedActiveDirectoryConfiguration property for this object.
     */
    public SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration() {
        return selfManagedActiveDirectoryConfiguration;
    }

    /**
     * <p>
     * Specifies the file system deployment type, valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate
     * temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in AWS Regions that
     * have a minimum of three Availability Zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about high availability Multi-AZ file systems, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High Availability for
     * Amazon FSx for Windows File Server</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link WindowsDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the file system deployment type, valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to
     *         tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in
     *         AWS Regions that have a minimum of three Availability Zones.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To learn more about high availability Multi-AZ file systems, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High
     *         Availability for Amazon FSx for Windows File Server</a>.
     * @see WindowsDeploymentType
     */
    public WindowsDeploymentType deploymentType() {
        return WindowsDeploymentType.fromValue(deploymentType);
    }

    /**
     * <p>
     * Specifies the file system deployment type, valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate
     * temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in AWS Regions that
     * have a minimum of three Availability Zones.
     * </p>
     * </li>
     * <li>
     * <p>
     * SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about high availability Multi-AZ file systems, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High Availability for
     * Amazon FSx for Windows File Server</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link WindowsDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return Specifies the file system deployment type, valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to
     *         tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in
     *         AWS Regions that have a minimum of three Availability Zones.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To learn more about high availability Multi-AZ file systems, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High
     *         Availability for Amazon FSx for Windows File Server</a>.
     * @see WindowsDeploymentType
     */
    public String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * <p>
     * Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in which
     * you want the preferred file server to be located. For in-AWS applications, we recommend that you launch your
     * clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ data transfer costs
     * and minimize latency.
     * </p>
     * 
     * @return Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in
     *         which you want the preferred file server to be located. For in-AWS applications, we recommend that you
     *         launch your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ
     *         data transfer costs and minimize latency.
     */
    public String preferredSubnetId() {
        return preferredSubnetId;
    }

    /**
     * <p>
     * The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to the <i>n</i>th increments,
     * between 2^3 (8) and 2^11 (2048).
     * </p>
     * 
     * @return The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to the <i>n</i>th
     *         increments, between 2^3 (8) and 2^11 (2048).
     */
    public Integer throughputCapacity() {
        return throughputCapacity;
    }

    /**
     * <p>
     * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone.
     * </p>
     * 
     * @return The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone.
     */
    public String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * The preferred time to take daily automatic backups, formatted HH:MM in the UTC time zone.
     * </p>
     * 
     * @return The preferred time to take daily automatic backups, formatted HH:MM in the UTC time zone.
     */
    public String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * The number of days to retain automatic backups. The default is to retain backups for 7 days. Setting this value
     * to 0 disables the creation of automatic backups. The maximum retention period for backups is 35 days.
     * </p>
     * 
     * @return The number of days to retain automatic backups. The default is to retain backups for 7 days. Setting this
     *         value to 0 disables the creation of automatic backups. The maximum retention period for backups is 35
     *         days.
     */
    public Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * A boolean flag indicating whether tags for the file system should be copied to backups. This value defaults to
     * false. If it's set to true, all tags for the file system are copied to all automatic and user-initiated backups
     * where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified
     * tags are copied to backups.
     * </p>
     * 
     * @return A boolean flag indicating whether tags for the file system should be copied to backups. This value
     *         defaults to false. If it's set to true, all tags for the file system are copied to all automatic and
     *         user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or
     *         more tags, only the specified tags are copied to backups.
     */
    public Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedActiveDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferredSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemWindowsConfiguration)) {
            return false;
        }
        CreateFileSystemWindowsConfiguration other = (CreateFileSystemWindowsConfiguration) obj;
        return Objects.equals(activeDirectoryId(), other.activeDirectoryId())
                && Objects.equals(selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(preferredSubnetId(), other.preferredSubnetId())
                && Objects.equals(throughputCapacity(), other.throughputCapacity())
                && Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFileSystemWindowsConfiguration").add("ActiveDirectoryId", activeDirectoryId())
                .add("SelfManagedActiveDirectoryConfiguration", selfManagedActiveDirectoryConfiguration())
                .add("DeploymentType", deploymentTypeAsString()).add("PreferredSubnetId", preferredSubnetId())
                .add("ThroughputCapacity", throughputCapacity()).add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("CopyTagsToBackups", copyTagsToBackups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveDirectoryId":
            return Optional.ofNullable(clazz.cast(activeDirectoryId()));
        case "SelfManagedActiveDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(selfManagedActiveDirectoryConfiguration()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "PreferredSubnetId":
            return Optional.ofNullable(clazz.cast(preferredSubnetId()));
        case "ThroughputCapacity":
            return Optional.ofNullable(clazz.cast(throughputCapacity()));
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemWindowsConfiguration, T> g) {
        return obj -> g.apply((CreateFileSystemWindowsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFileSystemWindowsConfiguration> {
        /**
         * <p>
         * The ID for an existing AWS Managed Microsoft Active Directory (AD) instance that the file system should join
         * when it's created.
         * </p>
         * 
         * @param activeDirectoryId
         *        The ID for an existing AWS Managed Microsoft Active Directory (AD) instance that the file system
         *        should join when it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryId(String activeDirectoryId);

        /**
         * Sets the value of the SelfManagedActiveDirectoryConfiguration property for this object.
         *
         * @param selfManagedActiveDirectoryConfiguration
         *        The new value for the SelfManagedActiveDirectoryConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration);

        /**
         * Sets the value of the SelfManagedActiveDirectoryConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link SelfManagedActiveDirectoryConfiguration.Builder}
         * avoiding the need to create one manually via {@link SelfManagedActiveDirectoryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelfManagedActiveDirectoryConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfiguration)}.
         * 
         * @param selfManagedActiveDirectoryConfiguration
         *        a consumer that will call methods on {@link SelfManagedActiveDirectoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfiguration)
         */
        default Builder selfManagedActiveDirectoryConfiguration(
                Consumer<SelfManagedActiveDirectoryConfiguration.Builder> selfManagedActiveDirectoryConfiguration) {
            return selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfiguration.builder()
                    .applyMutation(selfManagedActiveDirectoryConfiguration).build());
        }

        /**
         * <p>
         * Specifies the file system deployment type, valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate
         * temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in AWS Regions
         * that have a minimum of three Availability Zones.
         * </p>
         * </li>
         * <li>
         * <p>
         * SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To learn more about high availability Multi-AZ file systems, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High Availability
         * for Amazon FSx for Windows File Server</a>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the file system deployment type, valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to
         *        tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system
         *        in AWS Regions that have a minimum of three Availability Zones.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To learn more about high availability Multi-AZ file systems, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High
         *        Availability for Amazon FSx for Windows File Server</a>.
         * @see WindowsDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WindowsDeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Specifies the file system deployment type, valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate
         * temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in AWS Regions
         * that have a minimum of three Availability Zones.
         * </p>
         * </li>
         * <li>
         * <p>
         * SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To learn more about high availability Multi-AZ file systems, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High Availability
         * for Amazon FSx for Windows File Server</a>.
         * </p>
         * 
         * @param deploymentType
         *        Specifies the file system deployment type, valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        MULTI_AZ_1 - Deploys a high availability file system that is configured for Multi-AZ redundancy to
         *        tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system
         *        in AWS Regions that have a minimum of three Availability Zones.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To learn more about high availability Multi-AZ file systems, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> High
         *        Availability for Amazon FSx for Windows File Server</a>.
         * @see WindowsDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WindowsDeploymentType
         */
        Builder deploymentType(WindowsDeploymentType deploymentType);

        /**
         * <p>
         * Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in
         * which you want the preferred file server to be located. For in-AWS applications, we recommend that you launch
         * your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ data
         * transfer costs and minimize latency.
         * </p>
         * 
         * @param preferredSubnetId
         *        Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet
         *        in which you want the preferred file server to be located. For in-AWS applications, we recommend that
         *        you launch your clients in the same Availability Zone (AZ) as your preferred file server to reduce
         *        cross-AZ data transfer costs and minimize latency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredSubnetId(String preferredSubnetId);

        /**
         * <p>
         * The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to the <i>n</i>th
         * increments, between 2^3 (8) and 2^11 (2048).
         * </p>
         * 
         * @param throughputCapacity
         *        The throughput of an Amazon FSx file system, measured in megabytes per second, in 2 to the <i>n</i>th
         *        increments, between 2^3 (8) and 2^11 (2048).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputCapacity(Integer throughputCapacity);

        /**
         * <p>
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone.
         * </p>
         * 
         * @param weeklyMaintenanceStartTime
         *        The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * The preferred time to take daily automatic backups, formatted HH:MM in the UTC time zone.
         * </p>
         * 
         * @param dailyAutomaticBackupStartTime
         *        The preferred time to take daily automatic backups, formatted HH:MM in the UTC time zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * The number of days to retain automatic backups. The default is to retain backups for 7 days. Setting this
         * value to 0 disables the creation of automatic backups. The maximum retention period for backups is 35 days.
         * </p>
         * 
         * @param automaticBackupRetentionDays
         *        The number of days to retain automatic backups. The default is to retain backups for 7 days. Setting
         *        this value to 0 disables the creation of automatic backups. The maximum retention period for backups
         *        is 35 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * A boolean flag indicating whether tags for the file system should be copied to backups. This value defaults
         * to false. If it's set to true, all tags for the file system are copied to all automatic and user-initiated
         * backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only
         * the specified tags are copied to backups.
         * </p>
         * 
         * @param copyTagsToBackups
         *        A boolean flag indicating whether tags for the file system should be copied to backups. This value
         *        defaults to false. If it's set to true, all tags for the file system are copied to all automatic and
         *        user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one
         *        or more tags, only the specified tags are copied to backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);
    }

    static final class BuilderImpl implements Builder {
        private String activeDirectoryId;

        private SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration;

        private String deploymentType;

        private String preferredSubnetId;

        private Integer throughputCapacity;

        private String weeklyMaintenanceStartTime;

        private String dailyAutomaticBackupStartTime;

        private Integer automaticBackupRetentionDays;

        private Boolean copyTagsToBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemWindowsConfiguration model) {
            activeDirectoryId(model.activeDirectoryId);
            selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
            deploymentType(model.deploymentType);
            preferredSubnetId(model.preferredSubnetId);
            throughputCapacity(model.throughputCapacity);
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            copyTagsToBackups(model.copyTagsToBackups);
        }

        public final String getActiveDirectoryId() {
            return activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        public final SelfManagedActiveDirectoryConfiguration.Builder getSelfManagedActiveDirectoryConfiguration() {
            return selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfiguration selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfiguration.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration
                    .build() : null;
        }

        public final String getDeploymentTypeAsString() {
            return deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(WindowsDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getPreferredSubnetId() {
            return preferredSubnetId;
        }

        @Override
        public final Builder preferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
            return this;
        }

        public final void setPreferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
        }

        public final Integer getThroughputCapacity() {
            return throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public CreateFileSystemWindowsConfiguration build() {
            return new CreateFileSystemWindowsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
