/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountActivitiesRequest extends FreeTierRequest implements
        ToCopyableBuilder<ListAccountActivitiesRequest.Builder, ListAccountActivitiesRequest> {
    private static final SdkField<List<String>> FILTER_ACTIVITY_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("filterActivityStatuses")
            .getter(getter(ListAccountActivitiesRequest::filterActivityStatusesAsStrings))
            .setter(setter(Builder::filterActivityStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterActivityStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccountActivitiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAccountActivitiesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("languageCode").getter(getter(ListAccountActivitiesRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILTER_ACTIVITY_STATUSES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LANGUAGE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> filterActivityStatuses;

    private final String nextToken;

    private final Integer maxResults;

    private final String languageCode;

    private ListAccountActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.filterActivityStatuses = builder.filterActivityStatuses;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.languageCode = builder.languageCode;
    }

    /**
     * <p>
     * The activity status filter. This field can be used to filter the response by activities status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterActivityStatuses} method.
     * </p>
     * 
     * @return The activity status filter. This field can be used to filter the response by activities status.
     */
    public final List<ActivityStatus> filterActivityStatuses() {
        return FilterActivityStatusesCopier.copyStringToEnum(filterActivityStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterActivityStatuses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFilterActivityStatuses() {
        return filterActivityStatuses != null && !(filterActivityStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The activity status filter. This field can be used to filter the response by activities status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterActivityStatuses} method.
     * </p>
     * 
     * @return The activity status filter. This field can be used to filter the response by activities status.
     */
    public final List<String> filterActivityStatusesAsStrings() {
        return filterActivityStatuses;
    }

    /**
     * <p>
     * A token from a previous paginated response. If this is specified, the response includes records beginning from
     * this token (inclusive), up to the number specified by <code>maxResults</code>.
     * </p>
     * 
     * @return A token from a previous paginated response. If this is specified, the response includes records beginning
     *         from this token (inclusive), up to the number specified by <code>maxResults</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The language code used to return translated titles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to return translated titles.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code used to return translated titles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to return translated titles.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterActivityStatuses() ? filterActivityStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountActivitiesRequest)) {
            return false;
        }
        ListAccountActivitiesRequest other = (ListAccountActivitiesRequest) obj;
        return hasFilterActivityStatuses() == other.hasFilterActivityStatuses()
                && Objects.equals(filterActivityStatusesAsStrings(), other.filterActivityStatusesAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountActivitiesRequest")
                .add("FilterActivityStatuses", hasFilterActivityStatuses() ? filterActivityStatusesAsStrings() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("LanguageCode", languageCodeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterActivityStatuses":
            return Optional.ofNullable(clazz.cast(filterActivityStatusesAsStrings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "languageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterActivityStatuses", FILTER_ACTIVITY_STATUSES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountActivitiesRequest, T> g) {
        return obj -> g.apply((ListAccountActivitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FreeTierRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAccountActivitiesRequest> {
        /**
         * <p>
         * The activity status filter. This field can be used to filter the response by activities status.
         * </p>
         * 
         * @param filterActivityStatuses
         *        The activity status filter. This field can be used to filter the response by activities status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterActivityStatusesWithStrings(Collection<String> filterActivityStatuses);

        /**
         * <p>
         * The activity status filter. This field can be used to filter the response by activities status.
         * </p>
         * 
         * @param filterActivityStatuses
         *        The activity status filter. This field can be used to filter the response by activities status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterActivityStatusesWithStrings(String... filterActivityStatuses);

        /**
         * <p>
         * The activity status filter. This field can be used to filter the response by activities status.
         * </p>
         * 
         * @param filterActivityStatuses
         *        The activity status filter. This field can be used to filter the response by activities status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterActivityStatuses(Collection<ActivityStatus> filterActivityStatuses);

        /**
         * <p>
         * The activity status filter. This field can be used to filter the response by activities status.
         * </p>
         * 
         * @param filterActivityStatuses
         *        The activity status filter. This field can be used to filter the response by activities status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterActivityStatuses(ActivityStatus... filterActivityStatuses);

        /**
         * <p>
         * A token from a previous paginated response. If this is specified, the response includes records beginning
         * from this token (inclusive), up to the number specified by <code>maxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        A token from a previous paginated response. If this is specified, the response includes records
         *        beginning from this token (inclusive), up to the number specified by <code>maxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The language code used to return translated titles.
         * </p>
         * 
         * @param languageCode
         *        The language code used to return translated titles.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code used to return translated titles.
         * </p>
         * 
         * @param languageCode
         *        The language code used to return translated titles.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FreeTierRequest.BuilderImpl implements Builder {
        private List<String> filterActivityStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountActivitiesRequest model) {
            super(model);
            filterActivityStatusesWithStrings(model.filterActivityStatuses);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            languageCode(model.languageCode);
        }

        public final Collection<String> getFilterActivityStatuses() {
            if (filterActivityStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return filterActivityStatuses;
        }

        public final void setFilterActivityStatuses(Collection<String> filterActivityStatuses) {
            this.filterActivityStatuses = FilterActivityStatusesCopier.copy(filterActivityStatuses);
        }

        @Override
        public final Builder filterActivityStatusesWithStrings(Collection<String> filterActivityStatuses) {
            this.filterActivityStatuses = FilterActivityStatusesCopier.copy(filterActivityStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterActivityStatusesWithStrings(String... filterActivityStatuses) {
            filterActivityStatusesWithStrings(Arrays.asList(filterActivityStatuses));
            return this;
        }

        @Override
        public final Builder filterActivityStatuses(Collection<ActivityStatus> filterActivityStatuses) {
            this.filterActivityStatuses = FilterActivityStatusesCopier.copyEnumToString(filterActivityStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterActivityStatuses(ActivityStatus... filterActivityStatuses) {
            filterActivityStatuses(Arrays.asList(filterActivityStatuses));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountActivitiesRequest build() {
            return new ListAccountActivitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
