/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFreeTierUsageResponse extends FreeTierResponse implements
        ToCopyableBuilder<GetFreeTierUsageResponse.Builder, GetFreeTierUsageResponse> {
    private static final SdkField<List<FreeTierUsage>> FREE_TIER_USAGES_FIELD = SdkField
            .<List<FreeTierUsage>> builder(MarshallingType.LIST)
            .memberName("freeTierUsages")
            .getter(getter(GetFreeTierUsageResponse::freeTierUsages))
            .setter(setter(Builder::freeTierUsages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTierUsages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FreeTierUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(FreeTierUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetFreeTierUsageResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREE_TIER_USAGES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FreeTierUsage> freeTierUsages;

    private final String nextToken;

    private GetFreeTierUsageResponse(BuilderImpl builder) {
        super(builder);
        this.freeTierUsages = builder.freeTierUsages;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FreeTierUsages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFreeTierUsages() {
        return freeTierUsages != null && !(freeTierUsages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Free Tier usage objects that meet your filter expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFreeTierUsages} method.
     * </p>
     * 
     * @return The list of Free Tier usage objects that meet your filter expression.
     */
    public final List<FreeTierUsage> freeTierUsages() {
        return freeTierUsages;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFreeTierUsages() ? freeTierUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFreeTierUsageResponse)) {
            return false;
        }
        GetFreeTierUsageResponse other = (GetFreeTierUsageResponse) obj;
        return hasFreeTierUsages() == other.hasFreeTierUsages() && Objects.equals(freeTierUsages(), other.freeTierUsages())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFreeTierUsageResponse").add("FreeTierUsages", hasFreeTierUsages() ? freeTierUsages() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "freeTierUsages":
            return Optional.ofNullable(clazz.cast(freeTierUsages()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("freeTierUsages", FREE_TIER_USAGES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFreeTierUsageResponse, T> g) {
        return obj -> g.apply((GetFreeTierUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FreeTierResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFreeTierUsageResponse> {
        /**
         * <p>
         * The list of Free Tier usage objects that meet your filter expression.
         * </p>
         * 
         * @param freeTierUsages
         *        The list of Free Tier usage objects that meet your filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTierUsages(Collection<FreeTierUsage> freeTierUsages);

        /**
         * <p>
         * The list of Free Tier usage objects that meet your filter expression.
         * </p>
         * 
         * @param freeTierUsages
         *        The list of Free Tier usage objects that meet your filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTierUsages(FreeTierUsage... freeTierUsages);

        /**
         * <p>
         * The list of Free Tier usage objects that meet your filter expression.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.freetier.model.FreeTierUsage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.freetier.model.FreeTierUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.freetier.model.FreeTierUsage.Builder#build()} is called immediately
         * and its result is passed to {@link #freeTierUsages(List<FreeTierUsage>)}.
         * 
         * @param freeTierUsages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.freetier.model.FreeTierUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #freeTierUsages(java.util.Collection<FreeTierUsage>)
         */
        Builder freeTierUsages(Consumer<FreeTierUsage.Builder>... freeTierUsages);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FreeTierResponse.BuilderImpl implements Builder {
        private List<FreeTierUsage> freeTierUsages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFreeTierUsageResponse model) {
            super(model);
            freeTierUsages(model.freeTierUsages);
            nextToken(model.nextToken);
        }

        public final List<FreeTierUsage.Builder> getFreeTierUsages() {
            List<FreeTierUsage.Builder> result = FreeTierUsagesCopier.copyToBuilder(this.freeTierUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFreeTierUsages(Collection<FreeTierUsage.BuilderImpl> freeTierUsages) {
            this.freeTierUsages = FreeTierUsagesCopier.copyFromBuilder(freeTierUsages);
        }

        @Override
        public final Builder freeTierUsages(Collection<FreeTierUsage> freeTierUsages) {
            this.freeTierUsages = FreeTierUsagesCopier.copy(freeTierUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTierUsages(FreeTierUsage... freeTierUsages) {
            freeTierUsages(Arrays.asList(freeTierUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTierUsages(Consumer<FreeTierUsage.Builder>... freeTierUsages) {
            freeTierUsages(Stream.of(freeTierUsages).map(c -> FreeTierUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetFreeTierUsageResponse build() {
            return new GetFreeTierUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
