/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.Language;
import software.amazon.awssdk.services.frauddetector.model.NonEmptyListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleDetail> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleId").getter(RuleDetail.getter(RuleDetail::ruleId)).setter(RuleDetail.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RuleDetail.getter(RuleDetail::description)).setter(RuleDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(RuleDetail.getter(RuleDetail::detectorId)).setter(RuleDetail.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleVersion").getter(RuleDetail.getter(RuleDetail::ruleVersion)).setter(RuleDetail.setter(Builder::ruleVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleVersion").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(RuleDetail.getter(RuleDetail::expression)).setter(RuleDetail.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(RuleDetail.getter(RuleDetail::languageAsString)).setter(RuleDetail.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outcomes").getter(RuleDetail.getter(RuleDetail::outcomes)).setter(RuleDetail.setter(Builder::outcomes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedTime").getter(RuleDetail.getter(RuleDetail::lastUpdatedTime)).setter(RuleDetail.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdTime").getter(RuleDetail.getter(RuleDetail::createdTime)).setter(RuleDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RuleDetail.getter(RuleDetail::arn)).setter(RuleDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, DESCRIPTION_FIELD, DETECTOR_ID_FIELD, RULE_VERSION_FIELD, EXPRESSION_FIELD, LANGUAGE_FIELD, OUTCOMES_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleId;
    private final String description;
    private final String detectorId;
    private final String ruleVersion;
    private final String expression;
    private final String language;
    private final List<String> outcomes;
    private final String lastUpdatedTime;
    private final String createdTime;
    private final String arn;

    private RuleDetail(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.description = builder.description;
        this.detectorId = builder.detectorId;
        this.ruleVersion = builder.ruleVersion;
        this.expression = builder.expression;
        this.language = builder.language;
        this.outcomes = builder.outcomes;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String description() {
        return this.description;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String ruleVersion() {
        return this.ruleVersion;
    }

    public final String expression() {
        return this.expression;
    }

    public final Language language() {
        return Language.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public final boolean hasOutcomes() {
        return this.outcomes != null && !(this.outcomes instanceof SdkAutoConstructList);
    }

    public final List<String> outcomes() {
        return this.outcomes;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutcomes() ? this.outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDetail)) {
            return false;
        }
        RuleDetail other = (RuleDetail)obj;
        return Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.ruleVersion(), other.ruleVersion()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.languageAsString(), other.languageAsString()) && this.hasOutcomes() == other.hasOutcomes() && Objects.equals(this.outcomes(), other.outcomes()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"RuleDetail").add("RuleId", (Object)this.ruleId()).add("Description", (Object)this.description()).add("DetectorId", (Object)this.detectorId()).add("RuleVersion", (Object)this.ruleVersion()).add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("Language", (Object)this.languageAsString()).add("Outcomes", this.hasOutcomes() ? this.outcomes() : null).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "ruleVersion": {
                return Optional.ofNullable(clazz.cast(this.ruleVersion()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "outcomes": {
                return Optional.ofNullable(clazz.cast(this.outcomes()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleId", RULE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("ruleVersion", RULE_VERSION_FIELD);
        map.put("expression", EXPRESSION_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("outcomes", OUTCOMES_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleDetail, T> g) {
        return obj -> g.apply((RuleDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private String description;
        private String detectorId;
        private String ruleVersion;
        private String expression;
        private String language;
        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();
        private String lastUpdatedTime;
        private String createdTime;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDetail model) {
            this.ruleId(model.ruleId);
            this.description(model.description);
            this.detectorId(model.detectorId);
            this.ruleVersion(model.ruleVersion);
            this.expression(model.expression);
            this.language(model.language);
            this.outcomes(model.outcomes);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
            this.arn(model.arn);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getRuleVersion() {
            return this.ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (this.outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String ... outcomes) {
            this.outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public RuleDetail build() {
            return new RuleDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleDetail> {
        public Builder ruleId(String var1);

        public Builder description(String var1);

        public Builder detectorId(String var1);

        public Builder ruleVersion(String var1);

        public Builder expression(String var1);

        public Builder language(String var1);

        public Builder language(Language var1);

        public Builder outcomes(Collection<String> var1);

        public Builder outcomes(String ... var1);

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);

        public Builder arn(String var1);
    }
}

