/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.Detector;
import software.amazon.awssdk.services.frauddetector.model.DetectorListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDetectorsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetDetectorsResponse> {
    private static final SdkField<List<Detector>> DETECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectors").getter(GetDetectorsResponse.getter(GetDetectorsResponse::detectors)).setter(GetDetectorsResponse.setter(Builder::detectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Detector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetDetectorsResponse.getter(GetDetectorsResponse::nextToken)).setter(GetDetectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDetectorsResponse.memberNameToFieldInitializer();
    private final List<Detector> detectors;
    private final String nextToken;

    private GetDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.detectors = builder.detectors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDetectors() {
        return this.detectors != null && !(this.detectors instanceof SdkAutoConstructList);
    }

    public final List<Detector> detectors() {
        return this.detectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectors() ? this.detectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorsResponse)) {
            return false;
        }
        GetDetectorsResponse other = (GetDetectorsResponse)((Object)obj);
        return this.hasDetectors() == other.hasDetectors() && Objects.equals(this.detectors(), other.detectors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDetectorsResponse").add("Detectors", this.hasDetectors() ? this.detectors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectors": {
                return Optional.ofNullable(clazz.cast(this.detectors()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectors", DETECTORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDetectorsResponse, T> g) {
        return obj -> g.apply((GetDetectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<Detector> detectors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorsResponse model) {
            super(model);
            this.detectors(model.detectors);
            this.nextToken(model.nextToken);
        }

        public final List<Detector.Builder> getDetectors() {
            List<Detector.Builder> result = DetectorListCopier.copyToBuilder(this.detectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectors(Collection<Detector.BuilderImpl> detectors) {
            this.detectors = DetectorListCopier.copyFromBuilder(detectors);
        }

        @Override
        public final Builder detectors(Collection<Detector> detectors) {
            this.detectors = DetectorListCopier.copy(detectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(Detector ... detectors) {
            this.detectors(Arrays.asList(detectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(Consumer<Detector.Builder> ... detectors) {
            this.detectors(Stream.of(detectors).map(c -> (Detector)((Detector.Builder)Detector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDetectorsResponse build() {
            return new GetDetectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDetectorsResponse> {
        public Builder detectors(Collection<Detector> var1);

        public Builder detectors(Detector ... var1);

        public Builder detectors(Consumer<Detector.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

