/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.AllowDenyList;
import software.amazon.awssdk.services.frauddetector.model.AllowDenyListsCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetListsMetadataResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetListsMetadataResponse> {
    private static final SdkField<List<AllowDenyList>> LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lists").getter(GetListsMetadataResponse.getter(GetListsMetadataResponse::lists)).setter(GetListsMetadataResponse.setter(Builder::lists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AllowDenyList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetListsMetadataResponse.getter(GetListsMetadataResponse::nextToken)).setter(GetListsMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("lists", LISTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AllowDenyList> lists;
    private final String nextToken;

    private GetListsMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.lists = builder.lists;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLists() {
        return this.lists != null && !(this.lists instanceof SdkAutoConstructList);
    }

    public final List<AllowDenyList> lists() {
        return this.lists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLists() ? this.lists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetListsMetadataResponse)) {
            return false;
        }
        GetListsMetadataResponse other = (GetListsMetadataResponse)((Object)obj);
        return this.hasLists() == other.hasLists() && Objects.equals(this.lists(), other.lists()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetListsMetadataResponse").add("Lists", this.hasLists() ? this.lists() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lists": {
                return Optional.ofNullable(clazz.cast(this.lists()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetListsMetadataResponse, T> g) {
        return obj -> g.apply((GetListsMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<AllowDenyList> lists = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetListsMetadataResponse model) {
            super(model);
            this.lists(model.lists);
            this.nextToken(model.nextToken);
        }

        public final List<AllowDenyList.Builder> getLists() {
            List<AllowDenyList.Builder> result = AllowDenyListsCopier.copyToBuilder(this.lists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLists(Collection<AllowDenyList.BuilderImpl> lists) {
            this.lists = AllowDenyListsCopier.copyFromBuilder(lists);
        }

        @Override
        public final Builder lists(Collection<AllowDenyList> lists) {
            this.lists = AllowDenyListsCopier.copy(lists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lists(AllowDenyList ... lists) {
            this.lists(Arrays.asList(lists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lists(Consumer<AllowDenyList.Builder> ... lists) {
            this.lists(Stream.of(lists).map(c -> (AllowDenyList)((AllowDenyList.Builder)AllowDenyList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetListsMetadataResponse build() {
            return new GetListsMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetListsMetadataResponse> {
        public Builder lists(Collection<AllowDenyList> var1);

        public Builder lists(AllowDenyList ... var1);

        public Builder lists(Consumer<AllowDenyList.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

