/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.FilterCondition;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.PredictionTimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventPredictionsRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, ListEventPredictionsRequest> {
    private static final SdkField<FilterCondition> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventId").getter(ListEventPredictionsRequest.getter(ListEventPredictionsRequest::eventId)).setter(ListEventPredictionsRequest.setter(Builder::eventId)).constructor(FilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<FilterCondition> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventType").getter(ListEventPredictionsRequest.getter(ListEventPredictionsRequest::eventType)).setter(ListEventPredictionsRequest.setter(Builder::eventType)).constructor(FilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<FilterCondition> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("detectorId").getter(ListEventPredictionsRequest.getter(ListEventPredictionsRequest::detectorId)).setter(ListEventPredictionsRequest.setter(Builder::detectorId)).constructor(FilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<FilterCondition> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("detectorVersionId").getter(ListEventPredictionsRequest.getter(ListEventPredictionsRequest::detectorVersionId)).setter(ListEventPredictionsRequest.setter(Builder::detectorVersionId)).constructor(FilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("predictionTimeRange").getter(ListEventPredictionsRequest.getter(ListEventPredictionsRequest::predictionTimeRange)).setter(ListEventPredictionsRequest.setter(Builder::predictionTimeRange)).constructor(PredictionTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimeRange").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEventPredictionsRequest.getter(ListEventPredictionsRequest::nextToken)).setter(ListEventPredictionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEventPredictionsRequest.getter(ListEventPredictionsRequest::maxResults)).setter(ListEventPredictionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_FIELD, DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, PREDICTION_TIME_RANGE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventId", EVENT_ID_FIELD);
            this.put("eventType", EVENT_TYPE_FIELD);
            this.put("detectorId", DETECTOR_ID_FIELD);
            this.put("detectorVersionId", DETECTOR_VERSION_ID_FIELD);
            this.put("predictionTimeRange", PREDICTION_TIME_RANGE_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final FilterCondition eventId;
    private final FilterCondition eventType;
    private final FilterCondition detectorId;
    private final FilterCondition detectorVersionId;
    private final PredictionTimeRange predictionTimeRange;
    private final String nextToken;
    private final Integer maxResults;

    private ListEventPredictionsRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final FilterCondition eventId() {
        return this.eventId;
    }

    public final FilterCondition eventType() {
        return this.eventType;
    }

    public final FilterCondition detectorId() {
        return this.detectorId;
    }

    public final FilterCondition detectorVersionId() {
        return this.detectorVersionId;
    }

    public final PredictionTimeRange predictionTimeRange() {
        return this.predictionTimeRange;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventPredictionsRequest)) {
            return false;
        }
        ListEventPredictionsRequest other = (ListEventPredictionsRequest)((Object)obj);
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId()) && Objects.equals(this.predictionTimeRange(), other.predictionTimeRange()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventPredictionsRequest").add("EventId", (Object)this.eventId()).add("EventType", (Object)this.eventType()).add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).add("PredictionTimeRange", (Object)this.predictionTimeRange()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
            case "predictionTimeRange": {
                return Optional.ofNullable(clazz.cast(this.predictionTimeRange()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEventPredictionsRequest, T> g) {
        return obj -> g.apply((ListEventPredictionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private FilterCondition eventId;
        private FilterCondition eventType;
        private FilterCondition detectorId;
        private FilterCondition detectorVersionId;
        private PredictionTimeRange predictionTimeRange;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventPredictionsRequest model) {
            super(model);
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
            this.predictionTimeRange(model.predictionTimeRange);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final FilterCondition.Builder getEventId() {
            return this.eventId != null ? this.eventId.toBuilder() : null;
        }

        public final void setEventId(FilterCondition.BuilderImpl eventId) {
            this.eventId = eventId != null ? eventId.build() : null;
        }

        @Override
        public final Builder eventId(FilterCondition eventId) {
            this.eventId = eventId;
            return this;
        }

        public final FilterCondition.Builder getEventType() {
            return this.eventType != null ? this.eventType.toBuilder() : null;
        }

        public final void setEventType(FilterCondition.BuilderImpl eventType) {
            this.eventType = eventType != null ? eventType.build() : null;
        }

        @Override
        public final Builder eventType(FilterCondition eventType) {
            this.eventType = eventType;
            return this;
        }

        public final FilterCondition.Builder getDetectorId() {
            return this.detectorId != null ? this.detectorId.toBuilder() : null;
        }

        public final void setDetectorId(FilterCondition.BuilderImpl detectorId) {
            this.detectorId = detectorId != null ? detectorId.build() : null;
        }

        @Override
        public final Builder detectorId(FilterCondition detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final FilterCondition.Builder getDetectorVersionId() {
            return this.detectorVersionId != null ? this.detectorVersionId.toBuilder() : null;
        }

        public final void setDetectorVersionId(FilterCondition.BuilderImpl detectorVersionId) {
            this.detectorVersionId = detectorVersionId != null ? detectorVersionId.build() : null;
        }

        @Override
        public final Builder detectorVersionId(FilterCondition detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return this.predictionTimeRange != null ? this.predictionTimeRange.toBuilder() : null;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        @Override
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEventPredictionsRequest build() {
            return new ListEventPredictionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventPredictionsRequest> {
        public Builder eventId(FilterCondition var1);

        default public Builder eventId(Consumer<FilterCondition.Builder> eventId) {
            return this.eventId((FilterCondition)((FilterCondition.Builder)FilterCondition.builder().applyMutation(eventId)).build());
        }

        public Builder eventType(FilterCondition var1);

        default public Builder eventType(Consumer<FilterCondition.Builder> eventType) {
            return this.eventType((FilterCondition)((FilterCondition.Builder)FilterCondition.builder().applyMutation(eventType)).build());
        }

        public Builder detectorId(FilterCondition var1);

        default public Builder detectorId(Consumer<FilterCondition.Builder> detectorId) {
            return this.detectorId((FilterCondition)((FilterCondition.Builder)FilterCondition.builder().applyMutation(detectorId)).build());
        }

        public Builder detectorVersionId(FilterCondition var1);

        default public Builder detectorVersionId(Consumer<FilterCondition.Builder> detectorVersionId) {
            return this.detectorVersionId((FilterCondition)((FilterCondition.Builder)FilterCondition.builder().applyMutation(detectorVersionId)).build());
        }

        public Builder predictionTimeRange(PredictionTimeRange var1);

        default public Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return this.predictionTimeRange((PredictionTimeRange)((PredictionTimeRange.Builder)PredictionTimeRange.builder().applyMutation(predictionTimeRange)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

