/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.ExternalModelPredictionMapCopier;
import software.amazon.awssdk.services.frauddetector.model.ExternalModelSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalModelOutputs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalModelOutputs> {
    private static final SdkField<ExternalModelSummary> EXTERNAL_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalModel").getter(ExternalModelOutputs.getter(ExternalModelOutputs::externalModel)).setter(ExternalModelOutputs.setter(Builder::externalModel)).constructor(ExternalModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModel").build()}).build();
    private static final SdkField<Map<String, String>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("outputs").getter(ExternalModelOutputs.getter(ExternalModelOutputs::outputs)).setter(ExternalModelOutputs.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_MODEL_FIELD, OUTPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("externalModel", EXTERNAL_MODEL_FIELD);
            this.put("outputs", OUTPUTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ExternalModelSummary externalModel;
    private final Map<String, String> outputs;

    private ExternalModelOutputs(BuilderImpl builder) {
        this.externalModel = builder.externalModel;
        this.outputs = builder.outputs;
    }

    public final ExternalModelSummary externalModel() {
        return this.externalModel;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> outputs() {
        return this.outputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.externalModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalModelOutputs)) {
            return false;
        }
        ExternalModelOutputs other = (ExternalModelOutputs)obj;
        return Objects.equals(this.externalModel(), other.externalModel()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalModelOutputs").add("ExternalModel", (Object)this.externalModel()).add("Outputs", this.hasOutputs() ? this.outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "externalModel": {
                return Optional.ofNullable(clazz.cast(this.externalModel()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExternalModelOutputs, T> g) {
        return obj -> g.apply((ExternalModelOutputs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExternalModelSummary externalModel;
        private Map<String, String> outputs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalModelOutputs model) {
            this.externalModel(model.externalModel);
            this.outputs(model.outputs);
        }

        public final ExternalModelSummary.Builder getExternalModel() {
            return this.externalModel != null ? this.externalModel.toBuilder() : null;
        }

        public final void setExternalModel(ExternalModelSummary.BuilderImpl externalModel) {
            this.externalModel = externalModel != null ? externalModel.build() : null;
        }

        @Override
        public final Builder externalModel(ExternalModelSummary externalModel) {
            this.externalModel = externalModel;
            return this;
        }

        public final Map<String, String> getOutputs() {
            if (this.outputs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputs;
        }

        public final void setOutputs(Map<String, String> outputs) {
            this.outputs = ExternalModelPredictionMapCopier.copy(outputs);
        }

        @Override
        public final Builder outputs(Map<String, String> outputs) {
            this.outputs = ExternalModelPredictionMapCopier.copy(outputs);
            return this;
        }

        public ExternalModelOutputs build() {
            return new ExternalModelOutputs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalModelOutputs> {
        public Builder externalModel(ExternalModelSummary var1);

        default public Builder externalModel(Consumer<ExternalModelSummary.Builder> externalModel) {
            return this.externalModel((ExternalModelSummary)((ExternalModelSummary.Builder)ExternalModelSummary.builder().applyMutation(externalModel)).build());
        }

        public Builder outputs(Map<String, String> var1);
    }
}

