/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventPredictionMetadataRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, GetEventPredictionMetadataRequest> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(GetEventPredictionMetadataRequest.getter(GetEventPredictionMetadataRequest::eventId)).setter(GetEventPredictionMetadataRequest.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(GetEventPredictionMetadataRequest.getter(GetEventPredictionMetadataRequest::eventTypeName)).setter(GetEventPredictionMetadataRequest.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(GetEventPredictionMetadataRequest.getter(GetEventPredictionMetadataRequest::detectorId)).setter(GetEventPredictionMetadataRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersionId").getter(GetEventPredictionMetadataRequest.getter(GetEventPredictionMetadataRequest::detectorVersionId)).setter(GetEventPredictionMetadataRequest.setter(Builder::detectorVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final SdkField<String> PREDICTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("predictionTimestamp").getter(GetEventPredictionMetadataRequest.getter(GetEventPredictionMetadataRequest::predictionTimestamp)).setter(GetEventPredictionMetadataRequest.setter(Builder::predictionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_NAME_FIELD, DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, PREDICTION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventId", EVENT_ID_FIELD);
            this.put("eventTypeName", EVENT_TYPE_NAME_FIELD);
            this.put("detectorId", DETECTOR_ID_FIELD);
            this.put("detectorVersionId", DETECTOR_VERSION_ID_FIELD);
            this.put("predictionTimestamp", PREDICTION_TIMESTAMP_FIELD);
        }
    });
    private final String eventId;
    private final String eventTypeName;
    private final String detectorId;
    private final String detectorVersionId;
    private final String predictionTimestamp;

    private GetEventPredictionMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.predictionTimestamp = builder.predictionTimestamp;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String detectorVersionId() {
        return this.detectorVersionId;
    }

    public final String predictionTimestamp() {
        return this.predictionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionMetadataRequest)) {
            return false;
        }
        GetEventPredictionMetadataRequest other = (GetEventPredictionMetadataRequest)((Object)obj);
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId()) && Objects.equals(this.predictionTimestamp(), other.predictionTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventPredictionMetadataRequest").add("EventId", (Object)this.eventId()).add("EventTypeName", (Object)this.eventTypeName()).add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).add("PredictionTimestamp", (Object)this.predictionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
            case "predictionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.predictionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionMetadataRequest, T> g) {
        return obj -> g.apply((GetEventPredictionMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String eventId;
        private String eventTypeName;
        private String detectorId;
        private String detectorVersionId;
        private String predictionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionMetadataRequest model) {
            super(model);
            this.eventId(model.eventId);
            this.eventTypeName(model.eventTypeName);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
            this.predictionTimestamp(model.predictionTimestamp);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return this.detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getPredictionTimestamp() {
            return this.predictionTimestamp;
        }

        public final void setPredictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
        }

        @Override
        public final Builder predictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEventPredictionMetadataRequest build() {
            return new GetEventPredictionMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventPredictionMetadataRequest> {
        public Builder eventId(String var1);

        public Builder eventTypeName(String var1);

        public Builder detectorId(String var1);

        public Builder detectorVersionId(String var1);

        public Builder predictionTimestamp(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

