/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;

public class GetDetectorsPublisher
implements SdkPublisher<GetDetectorsResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetDetectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDetectorsPublisher(FraudDetectorAsyncClient client, GetDetectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDetectorsPublisher(FraudDetectorAsyncClient client, GetDetectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDetectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDetectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetDetectorsResponseFetcher
    implements AsyncPageFetcher<GetDetectorsResponse> {
        private GetDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(GetDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDetectorsResponse> nextPage(GetDetectorsResponse previousPage) {
            if (previousPage == null) {
                return GetDetectorsPublisher.this.client.getDetectors(GetDetectorsPublisher.this.firstRequest);
            }
            return GetDetectorsPublisher.this.client.getDetectors((GetDetectorsRequest)((Object)GetDetectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

