/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model version evalutions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelVersionEvaluation implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelVersionEvaluation.Builder, ModelVersionEvaluation> {
    private static final SdkField<String> OUTPUT_VARIABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputVariableName").getter(getter(ModelVersionEvaluation::outputVariableName))
            .setter(setter(Builder::outputVariableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariableName").build())
            .build();

    private static final SdkField<String> EVALUATION_SCORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationScore").getter(getter(ModelVersionEvaluation::evaluationScore))
            .setter(setter(Builder::evaluationScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationScore").build()).build();

    private static final SdkField<PredictionExplanations> PREDICTION_EXPLANATIONS_FIELD = SdkField
            .<PredictionExplanations> builder(MarshallingType.SDK_POJO).memberName("predictionExplanations")
            .getter(getter(ModelVersionEvaluation::predictionExplanations)).setter(setter(Builder::predictionExplanations))
            .constructor(PredictionExplanations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionExplanations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_VARIABLE_NAME_FIELD,
            EVALUATION_SCORE_FIELD, PREDICTION_EXPLANATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputVariableName;

    private final String evaluationScore;

    private final PredictionExplanations predictionExplanations;

    private ModelVersionEvaluation(BuilderImpl builder) {
        this.outputVariableName = builder.outputVariableName;
        this.evaluationScore = builder.evaluationScore;
        this.predictionExplanations = builder.predictionExplanations;
    }

    /**
     * <p>
     * The output variable name.
     * </p>
     * 
     * @return The output variable name.
     */
    public final String outputVariableName() {
        return outputVariableName;
    }

    /**
     * <p>
     * The evaluation score generated for the model version.
     * </p>
     * 
     * @return The evaluation score generated for the model version.
     */
    public final String evaluationScore() {
        return evaluationScore;
    }

    /**
     * <p>
     * The prediction explanations generated for the model version.
     * </p>
     * 
     * @return The prediction explanations generated for the model version.
     */
    public final PredictionExplanations predictionExplanations() {
        return predictionExplanations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputVariableName());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationScore());
        hashCode = 31 * hashCode + Objects.hashCode(predictionExplanations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionEvaluation)) {
            return false;
        }
        ModelVersionEvaluation other = (ModelVersionEvaluation) obj;
        return Objects.equals(outputVariableName(), other.outputVariableName())
                && Objects.equals(evaluationScore(), other.evaluationScore())
                && Objects.equals(predictionExplanations(), other.predictionExplanations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelVersionEvaluation").add("OutputVariableName", outputVariableName())
                .add("EvaluationScore", evaluationScore()).add("PredictionExplanations", predictionExplanations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputVariableName":
            return Optional.ofNullable(clazz.cast(outputVariableName()));
        case "evaluationScore":
            return Optional.ofNullable(clazz.cast(evaluationScore()));
        case "predictionExplanations":
            return Optional.ofNullable(clazz.cast(predictionExplanations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelVersionEvaluation, T> g) {
        return obj -> g.apply((ModelVersionEvaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelVersionEvaluation> {
        /**
         * <p>
         * The output variable name.
         * </p>
         * 
         * @param outputVariableName
         *        The output variable name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputVariableName(String outputVariableName);

        /**
         * <p>
         * The evaluation score generated for the model version.
         * </p>
         * 
         * @param evaluationScore
         *        The evaluation score generated for the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationScore(String evaluationScore);

        /**
         * <p>
         * The prediction explanations generated for the model version.
         * </p>
         * 
         * @param predictionExplanations
         *        The prediction explanations generated for the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionExplanations(PredictionExplanations predictionExplanations);

        /**
         * <p>
         * The prediction explanations generated for the model version.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictionExplanations.Builder} avoiding
         * the need to create one manually via {@link PredictionExplanations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictionExplanations.Builder#build()} is called immediately and
         * its result is passed to {@link #predictionExplanations(PredictionExplanations)}.
         * 
         * @param predictionExplanations
         *        a consumer that will call methods on {@link PredictionExplanations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictionExplanations(PredictionExplanations)
         */
        default Builder predictionExplanations(Consumer<PredictionExplanations.Builder> predictionExplanations) {
            return predictionExplanations(PredictionExplanations.builder().applyMutation(predictionExplanations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String outputVariableName;

        private String evaluationScore;

        private PredictionExplanations predictionExplanations;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersionEvaluation model) {
            outputVariableName(model.outputVariableName);
            evaluationScore(model.evaluationScore);
            predictionExplanations(model.predictionExplanations);
        }

        public final String getOutputVariableName() {
            return outputVariableName;
        }

        public final void setOutputVariableName(String outputVariableName) {
            this.outputVariableName = outputVariableName;
        }

        @Override
        public final Builder outputVariableName(String outputVariableName) {
            this.outputVariableName = outputVariableName;
            return this;
        }

        public final String getEvaluationScore() {
            return evaluationScore;
        }

        public final void setEvaluationScore(String evaluationScore) {
            this.evaluationScore = evaluationScore;
        }

        @Override
        public final Builder evaluationScore(String evaluationScore) {
            this.evaluationScore = evaluationScore;
            return this;
        }

        public final PredictionExplanations.Builder getPredictionExplanations() {
            return predictionExplanations != null ? predictionExplanations.toBuilder() : null;
        }

        public final void setPredictionExplanations(PredictionExplanations.BuilderImpl predictionExplanations) {
            this.predictionExplanations = predictionExplanations != null ? predictionExplanations.build() : null;
        }

        @Override
        public final Builder predictionExplanations(PredictionExplanations predictionExplanations) {
            this.predictionExplanations = predictionExplanations;
            return this;
        }

        @Override
        public ModelVersionEvaluation build() {
            return new ModelVersionEvaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
