/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the external (Amazon Sagemaker) model evaluated for generating predictions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluatedExternalModel implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluatedExternalModel.Builder, EvaluatedExternalModel> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelEndpoint").getter(getter(EvaluatedExternalModel::modelEndpoint))
            .setter(setter(Builder::modelEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()).build();

    private static final SdkField<Boolean> USE_EVENT_VARIABLES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useEventVariables").getter(getter(EvaluatedExternalModel::useEventVariables))
            .setter(setter(Builder::useEventVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useEventVariables").build()).build();

    private static final SdkField<Map<String, String>> INPUT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("inputVariables")
            .getter(getter(EvaluatedExternalModel::inputVariables))
            .setter(setter(Builder::inputVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> OUTPUT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("outputVariables")
            .getter(getter(EvaluatedExternalModel::outputVariables))
            .setter(setter(Builder::outputVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD,
            USE_EVENT_VARIABLES_FIELD, INPUT_VARIABLES_FIELD, OUTPUT_VARIABLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelEndpoint;

    private final Boolean useEventVariables;

    private final Map<String, String> inputVariables;

    private final Map<String, String> outputVariables;

    private EvaluatedExternalModel(BuilderImpl builder) {
        this.modelEndpoint = builder.modelEndpoint;
        this.useEventVariables = builder.useEventVariables;
        this.inputVariables = builder.inputVariables;
        this.outputVariables = builder.outputVariables;
    }

    /**
     * <p>
     * The endpoint of the external (Amazon Sagemaker) model.
     * </p>
     * 
     * @return The endpoint of the external (Amazon Sagemaker) model.
     */
    public final String modelEndpoint() {
        return modelEndpoint;
    }

    /**
     * <p>
     * Indicates whether event variables were used to generate predictions.
     * </p>
     * 
     * @return Indicates whether event variables were used to generate predictions.
     */
    public final Boolean useEventVariables() {
        return useEventVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputVariables() {
        return inputVariables != null && !(inputVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Input variables use for generating predictions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputVariables} method.
     * </p>
     * 
     * @return Input variables use for generating predictions.
     */
    public final Map<String, String> inputVariables() {
        return inputVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputVariables() {
        return outputVariables != null && !(outputVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Output variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputVariables} method.
     * </p>
     * 
     * @return Output variables.
     */
    public final Map<String, String> outputVariables() {
        return outputVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(useEventVariables());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputVariables() ? inputVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputVariables() ? outputVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedExternalModel)) {
            return false;
        }
        EvaluatedExternalModel other = (EvaluatedExternalModel) obj;
        return Objects.equals(modelEndpoint(), other.modelEndpoint())
                && Objects.equals(useEventVariables(), other.useEventVariables())
                && hasInputVariables() == other.hasInputVariables() && Objects.equals(inputVariables(), other.inputVariables())
                && hasOutputVariables() == other.hasOutputVariables()
                && Objects.equals(outputVariables(), other.outputVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluatedExternalModel").add("ModelEndpoint", modelEndpoint())
                .add("UseEventVariables", useEventVariables())
                .add("InputVariables", inputVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OutputVariables", outputVariables() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelEndpoint":
            return Optional.ofNullable(clazz.cast(modelEndpoint()));
        case "useEventVariables":
            return Optional.ofNullable(clazz.cast(useEventVariables()));
        case "inputVariables":
            return Optional.ofNullable(clazz.cast(inputVariables()));
        case "outputVariables":
            return Optional.ofNullable(clazz.cast(outputVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluatedExternalModel, T> g) {
        return obj -> g.apply((EvaluatedExternalModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluatedExternalModel> {
        /**
         * <p>
         * The endpoint of the external (Amazon Sagemaker) model.
         * </p>
         * 
         * @param modelEndpoint
         *        The endpoint of the external (Amazon Sagemaker) model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelEndpoint(String modelEndpoint);

        /**
         * <p>
         * Indicates whether event variables were used to generate predictions.
         * </p>
         * 
         * @param useEventVariables
         *        Indicates whether event variables were used to generate predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEventVariables(Boolean useEventVariables);

        /**
         * <p>
         * Input variables use for generating predictions.
         * </p>
         * 
         * @param inputVariables
         *        Input variables use for generating predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputVariables(Map<String, String> inputVariables);

        /**
         * <p>
         * Output variables.
         * </p>
         * 
         * @param outputVariables
         *        Output variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputVariables(Map<String, String> outputVariables);
    }

    static final class BuilderImpl implements Builder {
        private String modelEndpoint;

        private Boolean useEventVariables;

        private Map<String, String> inputVariables = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> outputVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatedExternalModel model) {
            modelEndpoint(model.modelEndpoint);
            useEventVariables(model.useEventVariables);
            inputVariables(model.inputVariables);
            outputVariables(model.outputVariables);
        }

        public final String getModelEndpoint() {
            return modelEndpoint;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final Boolean getUseEventVariables() {
            return useEventVariables;
        }

        public final void setUseEventVariables(Boolean useEventVariables) {
            this.useEventVariables = useEventVariables;
        }

        @Override
        public final Builder useEventVariables(Boolean useEventVariables) {
            this.useEventVariables = useEventVariables;
            return this;
        }

        public final Map<String, String> getInputVariables() {
            if (inputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return inputVariables;
        }

        public final void setInputVariables(Map<String, String> inputVariables) {
            this.inputVariables = MapOfStringsCopier.copy(inputVariables);
        }

        @Override
        public final Builder inputVariables(Map<String, String> inputVariables) {
            this.inputVariables = MapOfStringsCopier.copy(inputVariables);
            return this;
        }

        public final Map<String, String> getOutputVariables() {
            if (outputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return outputVariables;
        }

        public final void setOutputVariables(Map<String, String> outputVariables) {
            this.outputVariables = MapOfStringsCopier.copy(outputVariables);
        }

        @Override
        public final Builder outputVariables(Map<String, String> outputVariables) {
            this.outputVariables = MapOfStringsCopier.copy(outputVariables);
            return this;
        }

        @Override
        public EvaluatedExternalModel build() {
            return new EvaluatedExternalModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
