/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelVersionStatus {
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    TRAINING_CANCELLED("TRAINING_CANCELLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelVersionStatus> VALUE_MAP;
    private final String value;

    private ModelVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelVersionStatus> knownValues() {
        EnumSet<ModelVersionStatus> knownValues = EnumSet.allOf(ModelVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelVersionStatus.class, ModelVersionStatus::toString);
    }
}

