/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.NonEmptyListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.Tag;
import software.amazon.awssdk.services.frauddetector.model._tagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventTypeRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, PutEventTypeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PutEventTypeRequest.getter(PutEventTypeRequest::name)).setter(PutEventTypeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PutEventTypeRequest.getter(PutEventTypeRequest::description)).setter(PutEventTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EVENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventVariables").getter(PutEventTypeRequest.getter(PutEventTypeRequest::eventVariables)).setter(PutEventTypeRequest.setter(Builder::eventVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("labels").getter(PutEventTypeRequest.getter(PutEventTypeRequest::labels)).setter(PutEventTypeRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entityTypes").getter(PutEventTypeRequest.getter(PutEventTypeRequest::entityTypes)).setter(PutEventTypeRequest.setter(Builder::entityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(PutEventTypeRequest.getter(PutEventTypeRequest::tags)).setter(PutEventTypeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, EVENT_VARIABLES_FIELD, LABELS_FIELD, ENTITY_TYPES_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final List<String> eventVariables;
    private final List<String> labels;
    private final List<String> entityTypes;
    private final List<Tag> tags;

    private PutEventTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.eventVariables = builder.eventVariables;
        this.labels = builder.labels;
        this.entityTypes = builder.entityTypes;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEventVariables() {
        return this.eventVariables != null && !(this.eventVariables instanceof SdkAutoConstructList);
    }

    public final List<String> eventVariables() {
        return this.eventVariables;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final boolean hasEntityTypes() {
        return this.entityTypes != null && !(this.entityTypes instanceof SdkAutoConstructList);
    }

    public final List<String> entityTypes() {
        return this.entityTypes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventVariables() ? this.eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityTypes() ? this.entityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventTypeRequest)) {
            return false;
        }
        PutEventTypeRequest other = (PutEventTypeRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasEventVariables() == other.hasEventVariables() && Objects.equals(this.eventVariables(), other.eventVariables()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && this.hasEntityTypes() == other.hasEntityTypes() && Objects.equals(this.entityTypes(), other.entityTypes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventTypeRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("EventVariables", this.hasEventVariables() ? this.eventVariables() : null).add("Labels", this.hasLabels() ? this.labels() : null).add("EntityTypes", this.hasEntityTypes() ? this.entityTypes() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "eventVariables": {
                return Optional.ofNullable(clazz.cast(this.eventVariables()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "entityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypes()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventTypeRequest, T> g) {
        return obj -> g.apply((PutEventTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> eventVariables = DefaultSdkAutoConstructList.getInstance();
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventTypeRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.eventVariables(model.eventVariables);
            this.labels(model.labels);
            this.entityTypes(model.entityTypes);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getEventVariables() {
            if (this.eventVariables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventVariables;
        }

        @Override
        public final Builder eventVariables(Collection<String> eventVariables) {
            this.eventVariables = NonEmptyListOfStringsCopier.copy(eventVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventVariables(String ... eventVariables) {
            this.eventVariables(Arrays.asList(eventVariables));
            return this;
        }

        public final void setEventVariables(Collection<String> eventVariables) {
            this.eventVariables = NonEmptyListOfStringsCopier.copy(eventVariables);
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ListOfStringsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ListOfStringsCopier.copy(labels);
        }

        public final Collection<String> getEntityTypes() {
            if (this.entityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityTypes;
        }

        @Override
        public final Builder entityTypes(Collection<String> entityTypes) {
            this.entityTypes = NonEmptyListOfStringsCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(String ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = NonEmptyListOfStringsCopier.copy(entityTypes);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventTypeRequest build() {
            return new PutEventTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventTypeRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder eventVariables(Collection<String> var1);

        public Builder eventVariables(String ... var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder entityTypes(Collection<String> var1);

        public Builder entityTypes(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

