/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDetectorVersionRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<UpdateDetectorVersionRequest.Builder, UpdateDetectorVersionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(UpdateDetectorVersionRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionId").getter(getter(UpdateDetectorVersionRequest::detectorVersionId))
            .setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<List<String>> EXTERNAL_MODEL_ENDPOINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("externalModelEndpoints")
            .getter(getter(UpdateDetectorVersionRequest::externalModelEndpoints))
            .setter(setter(Builder::externalModelEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(UpdateDetectorVersionRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDetectorVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<ModelVersion>> MODEL_VERSIONS_FIELD = SdkField
            .<List<ModelVersion>> builder(MarshallingType.LIST)
            .memberName("modelVersions")
            .getter(getter(UpdateDetectorVersionRequest::modelVersions))
            .setter(setter(Builder::modelVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULE_EXECUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleExecutionMode").getter(getter(UpdateDetectorVersionRequest::ruleExecutionModeAsString))
            .setter(setter(Builder::ruleExecutionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DETECTOR_VERSION_ID_FIELD, EXTERNAL_MODEL_ENDPOINTS_FIELD, RULES_FIELD, DESCRIPTION_FIELD, MODEL_VERSIONS_FIELD,
            RULE_EXECUTION_MODE_FIELD));

    private final String detectorId;

    private final String detectorVersionId;

    private final List<String> externalModelEndpoints;

    private final List<Rule> rules;

    private final String description;

    private final List<ModelVersion> modelVersions;

    private final String ruleExecutionMode;

    private UpdateDetectorVersionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.externalModelEndpoints = builder.externalModelEndpoints;
        this.rules = builder.rules;
        this.description = builder.description;
        this.modelVersions = builder.modelVersions;
        this.ruleExecutionMode = builder.ruleExecutionMode;
    }

    /**
     * <p>
     * The parent detector ID for the detector version you want to update.
     * </p>
     * 
     * @return The parent detector ID for the detector version you want to update.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final String detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * Returns true if the ExternalModelEndpoints property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExternalModelEndpoints() {
        return externalModelEndpoints != null && !(externalModelEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon SageMaker model endpoints to include in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExternalModelEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon SageMaker model endpoints to include in the detector version.
     */
    public final List<String> externalModelEndpoints() {
        return externalModelEndpoints;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules to include in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rules to include in the detector version.
     */
    public final List<Rule> rules() {
        return rules;
    }

    /**
     * <p>
     * The detector version description.
     * </p>
     * 
     * @return The detector version description.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the ModelVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasModelVersions() {
        return modelVersions != null && !(modelVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model versions to include in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModelVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model versions to include in the detector version.
     */
    public final List<ModelVersion> modelVersions() {
        return modelVersions;
    }

    /**
     * <p>
     * The rule execution mode to add to the detector.
     * </p>
     * <p>
     * If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last,
     * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
     * </p>
     * <p>
     * If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for
     * all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft
     * status.
     * </p>
     * <p>
     * The default behavior is <code>FIRST_MATCHED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionMode}
     * will return {@link RuleExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionModeAsString}.
     * </p>
     * 
     * @return The rule execution mode to add to the detector.</p>
     *         <p>
     *         If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to
     *         last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that
     *         single rule.
     *         </p>
     *         <p>
     *         If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the
     *         outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when
     *         it is in draft status.
     *         </p>
     *         <p>
     *         The default behavior is <code>FIRST_MATCHED</code>.
     * @see RuleExecutionMode
     */
    public final RuleExecutionMode ruleExecutionMode() {
        return RuleExecutionMode.fromValue(ruleExecutionMode);
    }

    /**
     * <p>
     * The rule execution mode to add to the detector.
     * </p>
     * <p>
     * If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last,
     * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
     * </p>
     * <p>
     * If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for
     * all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft
     * status.
     * </p>
     * <p>
     * The default behavior is <code>FIRST_MATCHED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionMode}
     * will return {@link RuleExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionModeAsString}.
     * </p>
     * 
     * @return The rule execution mode to add to the detector.</p>
     *         <p>
     *         If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to
     *         last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that
     *         single rule.
     *         </p>
     *         <p>
     *         If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the
     *         outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when
     *         it is in draft status.
     *         </p>
     *         <p>
     *         The default behavior is <code>FIRST_MATCHED</code>.
     * @see RuleExecutionMode
     */
    public final String ruleExecutionModeAsString() {
        return ruleExecutionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalModelEndpoints() ? externalModelEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVersions() ? modelVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleExecutionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorVersionRequest)) {
            return false;
        }
        UpdateDetectorVersionRequest other = (UpdateDetectorVersionRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && hasExternalModelEndpoints() == other.hasExternalModelEndpoints()
                && Objects.equals(externalModelEndpoints(), other.externalModelEndpoints()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && Objects.equals(description(), other.description())
                && hasModelVersions() == other.hasModelVersions() && Objects.equals(modelVersions(), other.modelVersions())
                && Objects.equals(ruleExecutionModeAsString(), other.ruleExecutionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDetectorVersionRequest").add("DetectorId", detectorId())
                .add("DetectorVersionId", detectorVersionId())
                .add("ExternalModelEndpoints", hasExternalModelEndpoints() ? externalModelEndpoints() : null)
                .add("Rules", hasRules() ? rules() : null).add("Description", description())
                .add("ModelVersions", hasModelVersions() ? modelVersions() : null)
                .add("RuleExecutionMode", ruleExecutionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "externalModelEndpoints":
            return Optional.ofNullable(clazz.cast(externalModelEndpoints()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "modelVersions":
            return Optional.ofNullable(clazz.cast(modelVersions()));
        case "ruleExecutionMode":
            return Optional.ofNullable(clazz.cast(ruleExecutionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorVersionRequest, T> g) {
        return obj -> g.apply((UpdateDetectorVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDetectorVersionRequest> {
        /**
         * <p>
         * The parent detector ID for the detector version you want to update.
         * </p>
         * 
         * @param detectorId
         *        The parent detector ID for the detector version you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);

        /**
         * <p>
         * The Amazon SageMaker model endpoints to include in the detector version.
         * </p>
         * 
         * @param externalModelEndpoints
         *        The Amazon SageMaker model endpoints to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpoints(Collection<String> externalModelEndpoints);

        /**
         * <p>
         * The Amazon SageMaker model endpoints to include in the detector version.
         * </p>
         * 
         * @param externalModelEndpoints
         *        The Amazon SageMaker model endpoints to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpoints(String... externalModelEndpoints);

        /**
         * <p>
         * The rules to include in the detector version.
         * </p>
         * 
         * @param rules
         *        The rules to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * The rules to include in the detector version.
         * </p>
         * 
         * @param rules
         *        The rules to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * The rules to include in the detector version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Rule>.Builder} avoiding the need to create
         * one manually via {@link List<Rule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Rule>.Builder#build()} is called immediately and its result
         * is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<Rule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * The detector version description.
         * </p>
         * 
         * @param description
         *        The detector version description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The model versions to include in the detector version.
         * </p>
         * 
         * @param modelVersions
         *        The model versions to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersions(Collection<ModelVersion> modelVersions);

        /**
         * <p>
         * The model versions to include in the detector version.
         * </p>
         * 
         * @param modelVersions
         *        The model versions to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersions(ModelVersion... modelVersions);

        /**
         * <p>
         * The model versions to include in the detector version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelVersion>.Builder} avoiding the need to
         * create one manually via {@link List<ModelVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelVersion>.Builder#build()} is called immediately and its
         * result is passed to {@link #modelVersions(List<ModelVersion>)}.
         * 
         * @param modelVersions
         *        a consumer that will call methods on {@link List<ModelVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVersions(List<ModelVersion>)
         */
        Builder modelVersions(Consumer<ModelVersion.Builder>... modelVersions);

        /**
         * <p>
         * The rule execution mode to add to the detector.
         * </p>
         * <p>
         * If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last,
         * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
         * </p>
         * <p>
         * If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes
         * for all matched rules. You can define and edit the rule mode at the detector version level, when it is in
         * draft status.
         * </p>
         * <p>
         * The default behavior is <code>FIRST_MATCHED</code>.
         * </p>
         * 
         * @param ruleExecutionMode
         *        The rule execution mode to add to the detector.</p>
         *        <p>
         *        If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first
         *        to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for
         *        that single rule.
         *        </p>
         *        <p>
         *        If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the
         *        outcomes for all matched rules. You can define and edit the rule mode at the detector version level,
         *        when it is in draft status.
         *        </p>
         *        <p>
         *        The default behavior is <code>FIRST_MATCHED</code>.
         * @see RuleExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionMode
         */
        Builder ruleExecutionMode(String ruleExecutionMode);

        /**
         * <p>
         * The rule execution mode to add to the detector.
         * </p>
         * <p>
         * If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last,
         * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
         * </p>
         * <p>
         * If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes
         * for all matched rules. You can define and edit the rule mode at the detector version level, when it is in
         * draft status.
         * </p>
         * <p>
         * The default behavior is <code>FIRST_MATCHED</code>.
         * </p>
         * 
         * @param ruleExecutionMode
         *        The rule execution mode to add to the detector.</p>
         *        <p>
         *        If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first
         *        to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for
         *        that single rule.
         *        </p>
         *        <p>
         *        If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the
         *        outcomes for all matched rules. You can define and edit the rule mode at the detector version level,
         *        when it is in draft status.
         *        </p>
         *        <p>
         *        The default behavior is <code>FIRST_MATCHED</code>.
         * @see RuleExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionMode
         */
        Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String detectorVersionId;

        private List<String> externalModelEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<ModelVersion> modelVersions = DefaultSdkAutoConstructList.getInstance();

        private String ruleExecutionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorVersionRequest model) {
            super(model);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            externalModelEndpoints(model.externalModelEndpoints);
            rules(model.rules);
            description(model.description);
            modelVersions(model.modelVersions);
            ruleExecutionMode(model.ruleExecutionMode);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        public final Collection<String> getExternalModelEndpoints() {
            if (externalModelEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return externalModelEndpoints;
        }

        @Override
        public final Builder externalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModelEndpoints(String... externalModelEndpoints) {
            externalModelEndpoints(Arrays.asList(externalModelEndpoints));
            return this;
        }

        public final void setExternalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
        }

        public final Collection<Rule.Builder> getRules() {
            if (rules instanceof SdkAutoConstructList) {
                return null;
            }
            return rules != null ? rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ModelVersion.Builder> getModelVersions() {
            if (modelVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return modelVersions != null ? modelVersions.stream().map(ModelVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder modelVersions(Collection<ModelVersion> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copy(modelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(ModelVersion... modelVersions) {
            modelVersions(Arrays.asList(modelVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(Consumer<ModelVersion.Builder>... modelVersions) {
            modelVersions(Stream.of(modelVersions).map(c -> ModelVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModelVersions(Collection<ModelVersion.BuilderImpl> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copyFromBuilder(modelVersions);
        }

        public final String getRuleExecutionMode() {
            return ruleExecutionMode;
        }

        @Override
        public final Builder ruleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        @Override
        public final Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode) {
            this.ruleExecutionMode(ruleExecutionMode == null ? null : ruleExecutionMode.toString());
            return this;
        }

        public final void setRuleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorVersionRequest build() {
            return new UpdateDetectorVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
