/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<CreateRuleRequest.Builder, CreateRuleRequest> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ruleId")
            .getter(getter(CreateRuleRequest::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(CreateRuleRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateRuleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(CreateRuleRequest::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(CreateRuleRequest::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outcomes")
            .getter(getter(CreateRuleRequest::outcomes))
            .setter(setter(Builder::outcomes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD,
            DETECTOR_ID_FIELD, DESCRIPTION_FIELD, EXPRESSION_FIELD, LANGUAGE_FIELD, OUTCOMES_FIELD, TAGS_FIELD));

    private final String ruleId;

    private final String detectorId;

    private final String description;

    private final String expression;

    private final String language;

    private final List<String> outcomes;

    private final List<Tag> tags;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleId = builder.ruleId;
        this.detectorId = builder.detectorId;
        this.description = builder.description;
        this.expression = builder.expression;
        this.language = builder.language;
        this.outcomes = builder.outcomes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The rule ID.
     * </p>
     * 
     * @return The rule ID.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The detector ID for the rule's parent detector.
     * </p>
     * 
     * @return The detector ID for the rule's parent detector.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The rule description.
     * </p>
     * 
     * @return The rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The rule expression.
     * </p>
     * 
     * @return The rule expression.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The language of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The language of the rule.
     * @see Language
     */
    public final Language language() {
        return Language.fromValue(language);
    }

    /**
     * <p>
     * The language of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The language of the rule.
     * @see Language
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * Returns true if the Outcomes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutcomes() {
        return outcomes != null && !(outcomes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outcome or outcomes returned when the rule expression matches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutcomes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The outcome or outcomes returned when the rule expression matches.
     */
    public final List<String> outcomes() {
        return outcomes;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of key and value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key and value pairs.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomes() ? outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest) obj;
        return Objects.equals(ruleId(), other.ruleId()) && Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(description(), other.description()) && Objects.equals(expression(), other.expression())
                && Objects.equals(languageAsString(), other.languageAsString()) && hasOutcomes() == other.hasOutcomes()
                && Objects.equals(outcomes(), other.outcomes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleRequest").add("RuleId", ruleId()).add("DetectorId", detectorId())
                .add("Description", description())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Language", languageAsString()).add("Outcomes", hasOutcomes() ? outcomes() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "outcomes":
            return Optional.ofNullable(clazz.cast(outcomes()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleRequest> {
        /**
         * <p>
         * The rule ID.
         * </p>
         * 
         * @param ruleId
         *        The rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The detector ID for the rule's parent detector.
         * </p>
         * 
         * @param detectorId
         *        The detector ID for the rule's parent detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The rule description.
         * </p>
         * 
         * @param description
         *        The rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The rule expression.
         * </p>
         * 
         * @param expression
         *        The rule expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The language of the rule.
         * </p>
         * 
         * @param language
         *        The language of the rule.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(String language);

        /**
         * <p>
         * The language of the rule.
         * </p>
         * 
         * @param language
         *        The language of the rule.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(Language language);

        /**
         * <p>
         * The outcome or outcomes returned when the rule expression matches.
         * </p>
         * 
         * @param outcomes
         *        The outcome or outcomes returned when the rule expression matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Collection<String> outcomes);

        /**
         * <p>
         * The outcome or outcomes returned when the rule expression matches.
         * </p>
         * 
         * @param outcomes
         *        The outcome or outcomes returned when the rule expression matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(String... outcomes);

        /**
         * <p>
         * A collection of key and value pairs.
         * </p>
         * 
         * @param tags
         *        A collection of key and value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A collection of key and value pairs.
         * </p>
         * 
         * @param tags
         *        A collection of key and value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A collection of key and value pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String ruleId;

        private String detectorId;

        private String description;

        private String expression;

        private String language;

        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            ruleId(model.ruleId);
            detectorId(model.detectorId);
            description(model.description);
            expression(model.expression);
            language(model.language);
            outcomes(model.outcomes);
            tags(model.tags);
        }

        public final String getRuleId() {
            return ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExpression() {
            return expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Collection<String> getOutcomes() {
            if (outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return outcomes;
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String... outcomes) {
            outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
