/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.Model;
import software.amazon.awssdk.services.frauddetector.model._modelListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetModelsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetModelsResponse.getter(GetModelsResponse::nextToken)).setter(GetModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Model>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("models").getter(GetModelsResponse.getter(GetModelsResponse::models)).setter(GetModelsResponse.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Model::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODELS_FIELD));
    private final String nextToken;
    private final List<Model> models;

    private GetModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.models = builder.models;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public List<Model> models() {
        return this.models;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelsResponse)) {
            return false;
        }
        GetModelsResponse other = (GetModelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models());
    }

    public String toString() {
        return ToString.builder((String)"GetModelsResponse").add("NextToken", (Object)this.nextToken()).add("Models", this.hasModels() ? this.models() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelsResponse, T> g) {
        return obj -> g.apply((GetModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Model> models = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.models(model.models);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Model.Builder> getModels() {
            if (this.models instanceof SdkAutoConstructList) {
                return null;
            }
            return this.models != null ? (Collection)this.models.stream().map(Model::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder models(Collection<Model> models) {
            this.models = _modelListCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Model ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<Model.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (Model)((Model.Builder)Model.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<Model.BuilderImpl> models) {
            this.models = _modelListCopier.copyFromBuilder(models);
        }

        @Override
        public GetModelsResponse build() {
            return new GetModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetModelsResponse> {
        public Builder nextToken(String var1);

        public Builder models(Collection<Model> var1);

        public Builder models(Model ... var1);

        public Builder models(Consumer<Model.Builder> ... var1);
    }
}

