/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ModelTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetModelVersionRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, GetModelVersionRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionRequest.getter(GetModelVersionRequest::modelId)).setter(GetModelVersionRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionRequest.getter(GetModelVersionRequest::modelTypeAsString)).setter(GetModelVersionRequest.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> MODEL_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionRequest.getter(GetModelVersionRequest::modelVersionNumber)).setter(GetModelVersionRequest.setter(Builder::modelVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_TYPE_FIELD, MODEL_VERSION_NUMBER_FIELD));
    private final String modelId;
    private final String modelType;
    private final String modelVersionNumber;

    private GetModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.modelVersionNumber = builder.modelVersionNumber;
    }

    public String modelId() {
        return this.modelId;
    }

    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(this.modelType);
    }

    public String modelTypeAsString() {
        return this.modelType;
    }

    public String modelVersionNumber() {
        return this.modelVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelVersionRequest)) {
            return false;
        }
        GetModelVersionRequest other = (GetModelVersionRequest)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.modelVersionNumber(), other.modelVersionNumber());
    }

    public String toString() {
        return ToString.builder((String)"GetModelVersionRequest").add("ModelId", (Object)this.modelId()).add("ModelType", (Object)this.modelTypeAsString()).add("ModelVersionNumber", (Object)this.modelVersionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "modelVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.modelVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelVersionRequest, T> g) {
        return obj -> g.apply((GetModelVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String modelId;
        private String modelType;
        private String modelVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelVersionRequest model) {
            super(model);
            this.modelId(model.modelId);
            this.modelType(model.modelType);
            this.modelVersionNumber(model.modelVersionNumber);
        }

        public final String getModelId() {
            return this.modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelType() {
            return this.modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getModelVersionNumber() {
            return this.modelVersionNumber;
        }

        @Override
        public final Builder modelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
            return this;
        }

        public final void setModelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetModelVersionRequest build() {
            return new GetModelVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetModelVersionRequest> {
        public Builder modelId(String var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelTypeEnum var1);

        public Builder modelVersionNumber(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

