/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The variable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Variable implements SdkPojo, Serializable, ToCopyableBuilder<Variable.Builder, Variable> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::dataSourceAsString)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::variableType)).setter(setter(Builder::variableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Variable::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD,
            DATA_SOURCE_FIELD, DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, VARIABLE_TYPE_FIELD, LAST_UPDATED_TIME_FIELD,
            CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String dataType;

    private final String dataSource;

    private final String defaultValue;

    private final String description;

    private final String variableType;

    private final String lastUpdatedTime;

    private final String createdTime;

    private Variable(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.dataSource = builder.dataSource;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.variableType = builder.variableType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The name of the variable.
     * </p>
     * 
     * @return The name of the variable.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the variable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the variable.
     * @see DataType
     */
    public DataType dataType() {
        return DataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the variable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the variable.
     * @see DataType
     */
    public String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The data source of the variable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link DataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The data source of the variable.
     * @see DataSource
     */
    public DataSource dataSource() {
        return DataSource.fromValue(dataSource);
    }

    /**
     * <p>
     * The data source of the variable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link DataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The data source of the variable.
     * @see DataSource
     */
    public String dataSourceAsString() {
        return dataSource;
    }

    /**
     * <p>
     * The default value of the variable.
     * </p>
     * 
     * @return The default value of the variable.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The description of the variable.
     * </p>
     * 
     * @return The description of the variable.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The variable type of the variable.
     * </p>
     * 
     * @return The variable type of the variable.
     */
    public String variableType() {
        return variableType;
    }

    /**
     * <p>
     * The time when variable was last updated.
     * </p>
     * 
     * @return The time when variable was last updated.
     */
    public String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The time when the variable was created.
     * </p>
     * 
     * @return The time when the variable was created.
     */
    public String createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(variableType());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(dataSourceAsString(), other.dataSourceAsString())
                && Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(description(), other.description())
                && Objects.equals(variableType(), other.variableType())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Variable").add("Name", name()).add("DataType", dataTypeAsString())
                .add("DataSource", dataSourceAsString()).add("DefaultValue", defaultValue()).add("Description", description())
                .add("VariableType", variableType()).add("LastUpdatedTime", lastUpdatedTime()).add("CreatedTime", createdTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSourceAsString()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "variableType":
            return Optional.ofNullable(clazz.cast(variableType()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Variable, T> g) {
        return obj -> g.apply((Variable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Variable> {
        /**
         * <p>
         * The name of the variable.
         * </p>
         * 
         * @param name
         *        The name of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the variable.
         * </p>
         * 
         * @param dataType
         *        The data type of the variable.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the variable.
         * </p>
         * 
         * @param dataType
         *        The data type of the variable.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(DataType dataType);

        /**
         * <p>
         * The data source of the variable.
         * </p>
         * 
         * @param dataSource
         *        The data source of the variable.
         * @see DataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSource
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The data source of the variable.
         * </p>
         * 
         * @param dataSource
         *        The data source of the variable.
         * @see DataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSource
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The default value of the variable.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The description of the variable.
         * </p>
         * 
         * @param description
         *        The description of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The variable type of the variable.
         * </p>
         * 
         * @param variableType
         *        The variable type of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableType(String variableType);

        /**
         * <p>
         * The time when variable was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when variable was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The time when the variable was created.
         * </p>
         * 
         * @param createdTime
         *        The time when the variable was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String dataType;

        private String dataSource;

        private String defaultValue;

        private String description;

        private String variableType;

        private String lastUpdatedTime;

        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Variable model) {
            name(model.name);
            dataType(model.dataType);
            dataSource(model.dataSource);
            defaultValue(model.defaultValue);
            description(model.description);
            variableType(model.variableType);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVariableType() {
            return variableType;
        }

        @Override
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public Variable build() {
            return new Variable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
