/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the model version details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelVersionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelVersionDetail.Builder, ModelVersionDetail> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersionDetail::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersionDetail::modelTypeAsString)).setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<String> MODEL_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersionDetail::modelVersionNumber)).setter(setter(Builder::modelVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionNumber").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersionDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersionDetail::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TrainingDataSource> TRAINING_DATA_SOURCE_FIELD = SdkField
            .<TrainingDataSource> builder(MarshallingType.SDK_POJO).getter(getter(ModelVersionDetail::trainingDataSource))
            .setter(setter(Builder::trainingDataSource)).constructor(TrainingDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build())
            .build();

    private static final SdkField<List<ModelVariable>> MODEL_VARIABLES_FIELD = SdkField
            .<List<ModelVariable>> builder(MarshallingType.LIST)
            .getter(getter(ModelVersionDetail::modelVariables))
            .setter(setter(Builder::modelVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LabelSchema> LABEL_SCHEMA_FIELD = SdkField.<LabelSchema> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModelVersionDetail::labelSchema)).setter(setter(Builder::labelSchema))
            .constructor(LabelSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelSchema").build()).build();

    private static final SdkField<Map<String, String>> VALIDATION_METRICS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ModelVersionDetail::validationMetrics))
            .setter(setter(Builder::validationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMetrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TRAINING_METRICS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ModelVersionDetail::trainingMetrics))
            .setter(setter(Builder::trainingMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersionDetail::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersionDetail::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            MODEL_TYPE_FIELD, MODEL_VERSION_NUMBER_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, TRAINING_DATA_SOURCE_FIELD,
            MODEL_VARIABLES_FIELD, LABEL_SCHEMA_FIELD, VALIDATION_METRICS_FIELD, TRAINING_METRICS_FIELD, LAST_UPDATED_TIME_FIELD,
            CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelId;

    private final String modelType;

    private final String modelVersionNumber;

    private final String description;

    private final String status;

    private final TrainingDataSource trainingDataSource;

    private final List<ModelVariable> modelVariables;

    private final LabelSchema labelSchema;

    private final Map<String, String> validationMetrics;

    private final Map<String, String> trainingMetrics;

    private final String lastUpdatedTime;

    private final String createdTime;

    private ModelVersionDetail(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.modelVersionNumber = builder.modelVersionNumber;
        this.description = builder.description;
        this.status = builder.status;
        this.trainingDataSource = builder.trainingDataSource;
        this.modelVariables = builder.modelVariables;
        this.labelSchema = builder.labelSchema;
        this.validationMetrics = builder.validationMetrics;
        this.trainingMetrics = builder.trainingMetrics;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The model ID.
     * </p>
     * 
     * @return The model ID.
     */
    public String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(modelType);
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * The model version.
     * </p>
     * 
     * @return The model version.
     */
    public String modelVersionNumber() {
        return modelVersionNumber;
    }

    /**
     * <p>
     * The model description.
     * </p>
     * 
     * @return The model description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The model status.
     * </p>
     * 
     * @return The model status.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The model training data source.
     * </p>
     * 
     * @return The model training data source.
     */
    public TrainingDataSource trainingDataSource() {
        return trainingDataSource;
    }

    /**
     * Returns true if the ModelVariables property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasModelVariables() {
        return modelVariables != null && !(modelVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModelVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model variables.
     */
    public List<ModelVariable> modelVariables() {
        return modelVariables;
    }

    /**
     * <p>
     * The model label schema.
     * </p>
     * 
     * @return The model label schema.
     */
    public LabelSchema labelSchema() {
        return labelSchema;
    }

    /**
     * Returns true if the ValidationMetrics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidationMetrics() {
        return validationMetrics != null && !(validationMetrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The model validation metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model validation metrics.
     */
    public Map<String, String> validationMetrics() {
        return validationMetrics;
    }

    /**
     * Returns true if the TrainingMetrics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTrainingMetrics() {
        return trainingMetrics != null && !(trainingMetrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The model training metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrainingMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model training metrics.
     */
    public Map<String, String> trainingMetrics() {
        return trainingMetrics;
    }

    /**
     * <p>
     * The timestamp when the model was last updated.
     * </p>
     * 
     * @return The timestamp when the model was last updated.
     */
    public String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The timestamp when the model was created.
     * </p>
     * 
     * @return The timestamp when the model was created.
     */
    public String createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(modelVariables());
        hashCode = 31 * hashCode + Objects.hashCode(labelSchema());
        hashCode = 31 * hashCode + Objects.hashCode(validationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(trainingMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionDetail)) {
            return false;
        }
        ModelVersionDetail other = (ModelVersionDetail) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(modelTypeAsString(), other.modelTypeAsString())
                && Objects.equals(modelVersionNumber(), other.modelVersionNumber())
                && Objects.equals(description(), other.description()) && Objects.equals(status(), other.status())
                && Objects.equals(trainingDataSource(), other.trainingDataSource())
                && Objects.equals(modelVariables(), other.modelVariables()) && Objects.equals(labelSchema(), other.labelSchema())
                && Objects.equals(validationMetrics(), other.validationMetrics())
                && Objects.equals(trainingMetrics(), other.trainingMetrics())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelVersionDetail").add("ModelId", modelId()).add("ModelType", modelTypeAsString())
                .add("ModelVersionNumber", modelVersionNumber()).add("Description", description()).add("Status", status())
                .add("TrainingDataSource", trainingDataSource()).add("ModelVariables", modelVariables())
                .add("LabelSchema", labelSchema()).add("ValidationMetrics", validationMetrics())
                .add("TrainingMetrics", trainingMetrics()).add("LastUpdatedTime", lastUpdatedTime())
                .add("CreatedTime", createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "modelVersionNumber":
            return Optional.ofNullable(clazz.cast(modelVersionNumber()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "trainingDataSource":
            return Optional.ofNullable(clazz.cast(trainingDataSource()));
        case "modelVariables":
            return Optional.ofNullable(clazz.cast(modelVariables()));
        case "labelSchema":
            return Optional.ofNullable(clazz.cast(labelSchema()));
        case "validationMetrics":
            return Optional.ofNullable(clazz.cast(validationMetrics()));
        case "trainingMetrics":
            return Optional.ofNullable(clazz.cast(trainingMetrics()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelVersionDetail, T> g) {
        return obj -> g.apply((ModelVersionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelVersionDetail> {
        /**
         * <p>
         * The model ID.
         * </p>
         * 
         * @param modelId
         *        The model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(ModelTypeEnum modelType);

        /**
         * <p>
         * The model version.
         * </p>
         * 
         * @param modelVersionNumber
         *        The model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionNumber(String modelVersionNumber);

        /**
         * <p>
         * The model description.
         * </p>
         * 
         * @param description
         *        The model description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The model status.
         * </p>
         * 
         * @param status
         *        The model status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The model training data source.
         * </p>
         * 
         * @param trainingDataSource
         *        The model training data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSource(TrainingDataSource trainingDataSource);

        /**
         * <p>
         * The model training data source.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingDataSource.Builder} avoiding the need to
         * create one manually via {@link TrainingDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataSource(TrainingDataSource)}.
         * 
         * @param trainingDataSource
         *        a consumer that will call methods on {@link TrainingDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataSource(TrainingDataSource)
         */
        default Builder trainingDataSource(Consumer<TrainingDataSource.Builder> trainingDataSource) {
            return trainingDataSource(TrainingDataSource.builder().applyMutation(trainingDataSource).build());
        }

        /**
         * <p>
         * The model variables.
         * </p>
         * 
         * @param modelVariables
         *        The model variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariables(Collection<ModelVariable> modelVariables);

        /**
         * <p>
         * The model variables.
         * </p>
         * 
         * @param modelVariables
         *        The model variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariables(ModelVariable... modelVariables);

        /**
         * <p>
         * The model variables.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelVariable>.Builder} avoiding the need
         * to create one manually via {@link List<ModelVariable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelVariable>.Builder#build()} is called immediately and
         * its result is passed to {@link #modelVariables(List<ModelVariable>)}.
         * 
         * @param modelVariables
         *        a consumer that will call methods on {@link List<ModelVariable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVariables(List<ModelVariable>)
         */
        Builder modelVariables(Consumer<ModelVariable.Builder>... modelVariables);

        /**
         * <p>
         * The model label schema.
         * </p>
         * 
         * @param labelSchema
         *        The model label schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelSchema(LabelSchema labelSchema);

        /**
         * <p>
         * The model label schema.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelSchema.Builder} avoiding the need to create
         * one manually via {@link LabelSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelSchema.Builder#build()} is called immediately and its result
         * is passed to {@link #labelSchema(LabelSchema)}.
         * 
         * @param labelSchema
         *        a consumer that will call methods on {@link LabelSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelSchema(LabelSchema)
         */
        default Builder labelSchema(Consumer<LabelSchema.Builder> labelSchema) {
            return labelSchema(LabelSchema.builder().applyMutation(labelSchema).build());
        }

        /**
         * <p>
         * The model validation metrics.
         * </p>
         * 
         * @param validationMetrics
         *        The model validation metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMetrics(Map<String, String> validationMetrics);

        /**
         * <p>
         * The model training metrics.
         * </p>
         * 
         * @param trainingMetrics
         *        The model training metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingMetrics(Map<String, String> trainingMetrics);

        /**
         * <p>
         * The timestamp when the model was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the model was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The timestamp when the model was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String modelId;

        private String modelType;

        private String modelVersionNumber;

        private String description;

        private String status;

        private TrainingDataSource trainingDataSource;

        private List<ModelVariable> modelVariables = DefaultSdkAutoConstructList.getInstance();

        private LabelSchema labelSchema;

        private Map<String, String> validationMetrics = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> trainingMetrics = DefaultSdkAutoConstructMap.getInstance();

        private String lastUpdatedTime;

        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersionDetail model) {
            modelId(model.modelId);
            modelType(model.modelType);
            modelVersionNumber(model.modelVersionNumber);
            description(model.description);
            status(model.status);
            trainingDataSource(model.trainingDataSource);
            modelVariables(model.modelVariables);
            labelSchema(model.labelSchema);
            validationMetrics(model.validationMetrics);
            trainingMetrics(model.trainingMetrics);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
        }

        public final String getModelId() {
            return modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelType() {
            return modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getModelVersionNumber() {
            return modelVersionNumber;
        }

        @Override
        public final Builder modelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
            return this;
        }

        public final void setModelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final TrainingDataSource.Builder getTrainingDataSource() {
            return trainingDataSource != null ? trainingDataSource.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSource trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        public final void setTrainingDataSource(TrainingDataSource.BuilderImpl trainingDataSource) {
            this.trainingDataSource = trainingDataSource != null ? trainingDataSource.build() : null;
        }

        public final Collection<ModelVariable.Builder> getModelVariables() {
            return modelVariables != null ? modelVariables.stream().map(ModelVariable::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder modelVariables(Collection<ModelVariable> modelVariables) {
            this.modelVariables = ModelVariablesListCopier.copy(modelVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(ModelVariable... modelVariables) {
            modelVariables(Arrays.asList(modelVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariables(Consumer<ModelVariable.Builder>... modelVariables) {
            modelVariables(Stream.of(modelVariables).map(c -> ModelVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModelVariables(Collection<ModelVariable.BuilderImpl> modelVariables) {
            this.modelVariables = ModelVariablesListCopier.copyFromBuilder(modelVariables);
        }

        public final LabelSchema.Builder getLabelSchema() {
            return labelSchema != null ? labelSchema.toBuilder() : null;
        }

        @Override
        public final Builder labelSchema(LabelSchema labelSchema) {
            this.labelSchema = labelSchema;
            return this;
        }

        public final void setLabelSchema(LabelSchema.BuilderImpl labelSchema) {
            this.labelSchema = labelSchema != null ? labelSchema.build() : null;
        }

        public final Map<String, String> getValidationMetrics() {
            return validationMetrics;
        }

        @Override
        public final Builder validationMetrics(Map<String, String> validationMetrics) {
            this.validationMetrics = MetricsMapCopier.copy(validationMetrics);
            return this;
        }

        public final void setValidationMetrics(Map<String, String> validationMetrics) {
            this.validationMetrics = MetricsMapCopier.copy(validationMetrics);
        }

        public final Map<String, String> getTrainingMetrics() {
            return trainingMetrics;
        }

        @Override
        public final Builder trainingMetrics(Map<String, String> trainingMetrics) {
            this.trainingMetrics = MetricsMapCopier.copy(trainingMetrics);
            return this;
        }

        public final void setTrainingMetrics(Map<String, String> trainingMetrics) {
            this.trainingMetrics = MetricsMapCopier.copy(trainingMetrics);
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public ModelVersionDetail build() {
            return new ModelVersionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
