/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the model output configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelOutputConfiguration.Builder, ModelOutputConfiguration> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelOutputConfiguration::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<Map<String, String>> JSON_KEY_TO_VARIABLE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ModelOutputConfiguration::jsonKeyToVariableMap))
            .setter(setter(Builder::jsonKeyToVariableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonKeyToVariableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CSV_INDEX_TO_VARIABLE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ModelOutputConfiguration::csvIndexToVariableMap))
            .setter(setter(Builder::csvIndexToVariableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvIndexToVariableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            JSON_KEY_TO_VARIABLE_MAP_FIELD, CSV_INDEX_TO_VARIABLE_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final Map<String, String> jsonKeyToVariableMap;

    private final Map<String, String> csvIndexToVariableMap;

    private ModelOutputConfiguration(BuilderImpl builder) {
        this.format = builder.format;
        this.jsonKeyToVariableMap = builder.jsonKeyToVariableMap;
        this.csvIndexToVariableMap = builder.csvIndexToVariableMap;
    }

    /**
     * <p>
     * The format of the model output configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ModelOutputDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the model output configuration.
     * @see ModelOutputDataFormat
     */
    public ModelOutputDataFormat format() {
        return ModelOutputDataFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the model output configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ModelOutputDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the model output configuration.
     * @see ModelOutputDataFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * Returns true if the JsonKeyToVariableMap property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasJsonKeyToVariableMap() {
        return jsonKeyToVariableMap != null && !(jsonKeyToVariableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJsonKeyToVariableMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables.
     */
    public Map<String, String> jsonKeyToVariableMap() {
        return jsonKeyToVariableMap;
    }

    /**
     * Returns true if the CsvIndexToVariableMap property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCsvIndexToVariableMap() {
        return csvIndexToVariableMap != null && !(csvIndexToVariableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCsvIndexToVariableMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables.
     */
    public Map<String, String> csvIndexToVariableMap() {
        return csvIndexToVariableMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jsonKeyToVariableMap());
        hashCode = 31 * hashCode + Objects.hashCode(csvIndexToVariableMap());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelOutputConfiguration)) {
            return false;
        }
        ModelOutputConfiguration other = (ModelOutputConfiguration) obj;
        return Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(jsonKeyToVariableMap(), other.jsonKeyToVariableMap())
                && Objects.equals(csvIndexToVariableMap(), other.csvIndexToVariableMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelOutputConfiguration").add("Format", formatAsString())
                .add("JsonKeyToVariableMap", jsonKeyToVariableMap()).add("CsvIndexToVariableMap", csvIndexToVariableMap())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "jsonKeyToVariableMap":
            return Optional.ofNullable(clazz.cast(jsonKeyToVariableMap()));
        case "csvIndexToVariableMap":
            return Optional.ofNullable(clazz.cast(csvIndexToVariableMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelOutputConfiguration, T> g) {
        return obj -> g.apply((ModelOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelOutputConfiguration> {
        /**
         * <p>
         * The format of the model output configuration.
         * </p>
         * 
         * @param format
         *        The format of the model output configuration.
         * @see ModelOutputDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelOutputDataFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the model output configuration.
         * </p>
         * 
         * @param format
         *        The format of the model output configuration.
         * @see ModelOutputDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelOutputDataFormat
         */
        Builder format(ModelOutputDataFormat format);

        /**
         * <p>
         * A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables.
         * </p>
         * 
         * @param jsonKeyToVariableMap
         *        A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap);

        /**
         * <p>
         * A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables.
         * </p>
         * 
         * @param csvIndexToVariableMap
         *        A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvIndexToVariableMap(Map<String, String> csvIndexToVariableMap);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private Map<String, String> jsonKeyToVariableMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> csvIndexToVariableMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelOutputConfiguration model) {
            format(model.format);
            jsonKeyToVariableMap(model.jsonKeyToVariableMap);
            csvIndexToVariableMap(model.csvIndexToVariableMap);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ModelOutputDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Map<String, String> getJsonKeyToVariableMap() {
            return jsonKeyToVariableMap;
        }

        @Override
        public final Builder jsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
            this.jsonKeyToVariableMap = JsonKeyToVariableMapCopier.copy(jsonKeyToVariableMap);
            return this;
        }

        public final void setJsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
            this.jsonKeyToVariableMap = JsonKeyToVariableMapCopier.copy(jsonKeyToVariableMap);
        }

        public final Map<String, String> getCsvIndexToVariableMap() {
            return csvIndexToVariableMap;
        }

        @Override
        public final Builder csvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
            this.csvIndexToVariableMap = CsvIndexToVariableMapCopier.copy(csvIndexToVariableMap);
            return this;
        }

        public final void setCsvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
            this.csvIndexToVariableMap = CsvIndexToVariableMapCopier.copy(csvIndexToVariableMap);
        }

        @Override
        public ModelOutputConfiguration build() {
            return new ModelOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
