/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelSchema implements SdkPojo, Serializable, ToCopyableBuilder<LabelSchema.Builder, LabelSchema> {
    private static final SdkField<String> LABEL_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LabelSchema::labelKey)).setter(setter(Builder::labelKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelKey").build()).build();

    private static final SdkField<Map<String, List<String>>> LABEL_MAPPER_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(LabelSchema::labelMapper))
            .setter(setter(Builder::labelMapper))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelMapper").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_KEY_FIELD,
            LABEL_MAPPER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String labelKey;

    private final Map<String, List<String>> labelMapper;

    private LabelSchema(BuilderImpl builder) {
        this.labelKey = builder.labelKey;
        this.labelMapper = builder.labelMapper;
    }

    /**
     * <p>
     * The label key.
     * </p>
     * 
     * @return The label key.
     */
    public String labelKey() {
        return labelKey;
    }

    /**
     * Returns true if the LabelMapper property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLabelMapper() {
        return labelMapper != null && !(labelMapper instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The label mapper maps the Amazon Fraud Detector supported label to the appropriate source labels. For example, if
     * <code>"FRAUD"</code> and <code>"LEGIT"</code> are Amazon Fraud Detector supported labels, this mapper could be:
     * <code>{"FRAUD" =&gt; ["0"]</code>, "LEGIT" =&gt; ["1"]} or
     * <code>{"FRAUD" =&gt; ["false"], "LEGIT" =&gt; ["true"]}</code> or
     * <code>{"FRAUD" =&gt; ["fraud", "abuse"], "LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is
     * a list, because you may have multiple variants for a single Amazon Fraud Detector label.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabelMapper()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The label mapper maps the Amazon Fraud Detector supported label to the appropriate source labels. For
     *         example, if <code>"FRAUD"</code> and <code>"LEGIT"</code> are Amazon Fraud Detector supported labels,
     *         this mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, "LEGIT" =&gt; ["1"]} or
     *         <code>{"FRAUD" =&gt; ["false"], "LEGIT" =&gt; ["true"]}</code> or
     *         <code>{"FRAUD" =&gt; ["fraud", "abuse"], "LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the
     *         mapper is a list, because you may have multiple variants for a single Amazon Fraud Detector label.
     */
    public Map<String, List<String>> labelMapper() {
        return labelMapper;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelKey());
        hashCode = 31 * hashCode + Objects.hashCode(labelMapper());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelSchema)) {
            return false;
        }
        LabelSchema other = (LabelSchema) obj;
        return Objects.equals(labelKey(), other.labelKey()) && Objects.equals(labelMapper(), other.labelMapper());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LabelSchema").add("LabelKey", labelKey()).add("LabelMapper", labelMapper()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "labelKey":
            return Optional.ofNullable(clazz.cast(labelKey()));
        case "labelMapper":
            return Optional.ofNullable(clazz.cast(labelMapper()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelSchema, T> g) {
        return obj -> g.apply((LabelSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelSchema> {
        /**
         * <p>
         * The label key.
         * </p>
         * 
         * @param labelKey
         *        The label key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelKey(String labelKey);

        /**
         * <p>
         * The label mapper maps the Amazon Fraud Detector supported label to the appropriate source labels. For
         * example, if <code>"FRAUD"</code> and <code>"LEGIT"</code> are Amazon Fraud Detector supported labels, this
         * mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, "LEGIT" =&gt; ["1"]} or
         * <code>{"FRAUD" =&gt; ["false"], "LEGIT" =&gt; ["true"]}</code> or
         * <code>{"FRAUD" =&gt; ["fraud", "abuse"], "LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the
         * mapper is a list, because you may have multiple variants for a single Amazon Fraud Detector label.
         * </p>
         * 
         * @param labelMapper
         *        The label mapper maps the Amazon Fraud Detector supported label to the appropriate source labels. For
         *        example, if <code>"FRAUD"</code> and <code>"LEGIT"</code> are Amazon Fraud Detector supported labels,
         *        this mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, "LEGIT" =&gt; ["1"]} or
         *        <code>{"FRAUD" =&gt; ["false"], "LEGIT" =&gt; ["true"]}</code> or
         *        <code>{"FRAUD" =&gt; ["fraud", "abuse"], "LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of
         *        the mapper is a list, because you may have multiple variants for a single Amazon Fraud Detector label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelMapper(Map<String, ? extends Collection<String>> labelMapper);
    }

    static final class BuilderImpl implements Builder {
        private String labelKey;

        private Map<String, List<String>> labelMapper = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LabelSchema model) {
            labelKey(model.labelKey);
            labelMapper(model.labelMapper);
        }

        public final String getLabelKey() {
            return labelKey;
        }

        @Override
        public final Builder labelKey(String labelKey) {
            this.labelKey = labelKey;
            return this;
        }

        public final void setLabelKey(String labelKey) {
            this.labelKey = labelKey;
        }

        public final Map<String, ? extends Collection<String>> getLabelMapper() {
            return labelMapper;
        }

        @Override
        public final Builder labelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = LabelMapperCopier.copy(labelMapper);
            return this;
        }

        public final void setLabelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = LabelMapperCopier.copy(labelMapper);
        }

        @Override
        public LabelSchema build() {
            return new LabelSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
