/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPredictionResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetPredictionResponse.Builder, GetPredictionResponse> {
    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetPredictionResponse::outcomes))
            .setter(setter(Builder::outcomes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ModelScores>> MODEL_SCORES_FIELD = SdkField
            .<List<ModelScores>> builder(MarshallingType.LIST)
            .getter(getter(GetPredictionResponse::modelScores))
            .setter(setter(Builder::modelScores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelScores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelScores> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelScores::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleResult>> RULE_RESULTS_FIELD = SdkField
            .<List<RuleResult>> builder(MarshallingType.LIST)
            .getter(getter(GetPredictionResponse::ruleResults))
            .setter(setter(Builder::ruleResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTCOMES_FIELD,
            MODEL_SCORES_FIELD, RULE_RESULTS_FIELD));

    private final List<String> outcomes;

    private final List<ModelScores> modelScores;

    private final List<RuleResult> ruleResults;

    private GetPredictionResponse(BuilderImpl builder) {
        super(builder);
        this.outcomes = builder.outcomes;
        this.modelScores = builder.modelScores;
        this.ruleResults = builder.ruleResults;
    }

    /**
     * Returns true if the Outcomes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOutcomes() {
        return outcomes != null && !(outcomes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The prediction outcomes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutcomes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The prediction outcomes.
     */
    public List<String> outcomes() {
        return outcomes;
    }

    /**
     * Returns true if the ModelScores property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasModelScores() {
        return modelScores != null && !(modelScores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model scores for models used in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModelScores()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model scores for models used in the detector version.
     */
    public List<ModelScores> modelScores() {
        return modelScores;
    }

    /**
     * Returns true if the RuleResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRuleResults() {
        return ruleResults != null && !(ruleResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule results in the prediction.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rule results in the prediction.
     */
    public List<RuleResult> ruleResults() {
        return ruleResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outcomes());
        hashCode = 31 * hashCode + Objects.hashCode(modelScores());
        hashCode = 31 * hashCode + Objects.hashCode(ruleResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPredictionResponse)) {
            return false;
        }
        GetPredictionResponse other = (GetPredictionResponse) obj;
        return Objects.equals(outcomes(), other.outcomes()) && Objects.equals(modelScores(), other.modelScores())
                && Objects.equals(ruleResults(), other.ruleResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPredictionResponse").add("Outcomes", outcomes()).add("ModelScores", modelScores())
                .add("RuleResults", ruleResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outcomes":
            return Optional.ofNullable(clazz.cast(outcomes()));
        case "modelScores":
            return Optional.ofNullable(clazz.cast(modelScores()));
        case "ruleResults":
            return Optional.ofNullable(clazz.cast(ruleResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPredictionResponse, T> g) {
        return obj -> g.apply((GetPredictionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPredictionResponse> {
        /**
         * <p>
         * The prediction outcomes.
         * </p>
         * 
         * @param outcomes
         *        The prediction outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Collection<String> outcomes);

        /**
         * <p>
         * The prediction outcomes.
         * </p>
         * 
         * @param outcomes
         *        The prediction outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(String... outcomes);

        /**
         * <p>
         * The model scores for models used in the detector version.
         * </p>
         * 
         * @param modelScores
         *        The model scores for models used in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelScores(Collection<ModelScores> modelScores);

        /**
         * <p>
         * The model scores for models used in the detector version.
         * </p>
         * 
         * @param modelScores
         *        The model scores for models used in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelScores(ModelScores... modelScores);

        /**
         * <p>
         * The model scores for models used in the detector version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelScores>.Builder} avoiding the need to
         * create one manually via {@link List<ModelScores>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelScores>.Builder#build()} is called immediately and its
         * result is passed to {@link #modelScores(List<ModelScores>)}.
         * 
         * @param modelScores
         *        a consumer that will call methods on {@link List<ModelScores>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelScores(List<ModelScores>)
         */
        Builder modelScores(Consumer<ModelScores.Builder>... modelScores);

        /**
         * <p>
         * The rule results in the prediction.
         * </p>
         * 
         * @param ruleResults
         *        The rule results in the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleResults(Collection<RuleResult> ruleResults);

        /**
         * <p>
         * The rule results in the prediction.
         * </p>
         * 
         * @param ruleResults
         *        The rule results in the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleResults(RuleResult... ruleResults);

        /**
         * <p>
         * The rule results in the prediction.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleResult>.Builder} avoiding the need to
         * create one manually via {@link List<RuleResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleResult>.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleResults(List<RuleResult>)}.
         * 
         * @param ruleResults
         *        a consumer that will call methods on {@link List<RuleResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleResults(List<RuleResult>)
         */
        Builder ruleResults(Consumer<RuleResult.Builder>... ruleResults);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();

        private List<ModelScores> modelScores = DefaultSdkAutoConstructList.getInstance();

        private List<RuleResult> ruleResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPredictionResponse model) {
            super(model);
            outcomes(model.outcomes);
            modelScores(model.modelScores);
            ruleResults(model.ruleResults);
        }

        public final Collection<String> getOutcomes() {
            return outcomes;
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String... outcomes) {
            outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        public final Collection<ModelScores.Builder> getModelScores() {
            return modelScores != null ? modelScores.stream().map(ModelScores::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modelScores(Collection<ModelScores> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copy(modelScores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(ModelScores... modelScores) {
            modelScores(Arrays.asList(modelScores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(Consumer<ModelScores.Builder>... modelScores) {
            modelScores(Stream.of(modelScores).map(c -> ModelScores.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModelScores(Collection<ModelScores.BuilderImpl> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copyFromBuilder(modelScores);
        }

        public final Collection<RuleResult.Builder> getRuleResults() {
            return ruleResults != null ? ruleResults.stream().map(RuleResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleResults(Collection<RuleResult> ruleResults) {
            this.ruleResults = ListOfRuleResultsCopier.copy(ruleResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(RuleResult... ruleResults) {
            ruleResults(Arrays.asList(ruleResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(Consumer<RuleResult.Builder>... ruleResults) {
            ruleResults(Stream.of(ruleResults).map(c -> RuleResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRuleResults(Collection<RuleResult.BuilderImpl> ruleResults) {
            this.ruleResults = ListOfRuleResultsCopier.copyFromBuilder(ruleResults);
        }

        @Override
        public GetPredictionResponse build() {
            return new GetPredictionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
