/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuleMetadataRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<UpdateRuleMetadataRequest.Builder, UpdateRuleMetadataRequest> {
    private static final SdkField<Rule> RULE_FIELD = SdkField.<Rule> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateRuleMetadataRequest::rule)).setter(setter(Builder::rule)).constructor(Rule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRuleMetadataRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(RULE_FIELD, DESCRIPTION_FIELD));

    private final Rule rule;

    private final String description;

    private UpdateRuleMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
        this.description = builder.description;
    }

    /**
     * <p>
     * The rule to update.
     * </p>
     * 
     * @return The rule to update.
     */
    public Rule rule() {
        return rule;
    }

    /**
     * <p>
     * The rule description.
     * </p>
     * 
     * @return The rule description.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleMetadataRequest)) {
            return false;
        }
        UpdateRuleMetadataRequest other = (UpdateRuleMetadataRequest) obj;
        return Objects.equals(rule(), other.rule()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRuleMetadataRequest").add("Rule", rule()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleMetadataRequest, T> g) {
        return obj -> g.apply((UpdateRuleMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRuleMetadataRequest> {
        /**
         * <p>
         * The rule to update.
         * </p>
         * 
         * @param rule
         *        The rule to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(Rule rule);

        /**
         * <p>
         * The rule to update.
         * </p>
         * This is a convenience that creates an instance of the {@link Rule.Builder} avoiding the need to create one
         * manually via {@link Rule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rule.Builder#build()} is called immediately and its result is
         * passed to {@link #rule(Rule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(Rule)
         */
        default Builder rule(Consumer<Rule.Builder> rule) {
            return rule(Rule.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * The rule description.
         * </p>
         * 
         * @param description
         *        The rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private Rule rule;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleMetadataRequest model) {
            super(model);
            rule(model.rule);
            description(model.description);
        }

        public final Rule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleMetadataRequest build() {
            return new UpdateRuleMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
