/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model input configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInputConfiguration.Builder, ModelInputConfiguration> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelInputConfiguration::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<Boolean> IS_OPAQUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModelInputConfiguration::isOpaque)).setter(setter(Builder::isOpaque))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isOpaque").build()).build();

    private static final SdkField<String> JSON_INPUT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelInputConfiguration::jsonInputTemplate)).setter(setter(Builder::jsonInputTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonInputTemplate").build()).build();

    private static final SdkField<String> CSV_INPUT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelInputConfiguration::csvInputTemplate)).setter(setter(Builder::csvInputTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvInputTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, IS_OPAQUE_FIELD,
            JSON_INPUT_TEMPLATE_FIELD, CSV_INPUT_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final Boolean isOpaque;

    private final String jsonInputTemplate;

    private final String csvInputTemplate;

    private ModelInputConfiguration(BuilderImpl builder) {
        this.format = builder.format;
        this.isOpaque = builder.isOpaque;
        this.jsonInputTemplate = builder.jsonInputTemplate;
        this.csvInputTemplate = builder.csvInputTemplate;
    }

    /**
     * <p>
     * The format of the model input configuration. The format differs depending on if it is passed through to SageMaker
     * or constructed by Amazon Fraud Detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ModelInputDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the model input configuration. The format differs depending on if it is passed through to
     *         SageMaker or constructed by Amazon Fraud Detector.
     * @see ModelInputDataFormat
     */
    public ModelInputDataFormat format() {
        return ModelInputDataFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the model input configuration. The format differs depending on if it is passed through to SageMaker
     * or constructed by Amazon Fraud Detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ModelInputDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the model input configuration. The format differs depending on if it is passed through to
     *         SageMaker or constructed by Amazon Fraud Detector.
     * @see ModelInputDataFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * For an opaque-model, the input to the model will be a ByteBuffer blob provided in the getPrediction request, and
     * will be passed to SageMaker as-is. For non-opaque models, the input will be constructed by Amazon Fraud Detector
     * based on the model-configuration.
     * </p>
     * 
     * @return For an opaque-model, the input to the model will be a ByteBuffer blob provided in the getPrediction
     *         request, and will be passed to SageMaker as-is. For non-opaque models, the input will be constructed by
     *         Amazon Fraud Detector based on the model-configuration.
     */
    public Boolean isOpaque() {
        return isOpaque;
    }

    /**
     * <p>
     * Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders for
     * variable names in the template will be replaced with the variable values before being sent to SageMaker.
     * </p>
     * 
     * @return Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders
     *         for variable names in the template will be replaced with the variable values before being sent to
     *         SageMaker.
     */
    public String jsonInputTemplate() {
        return jsonInputTemplate;
    }

    /**
     * <p>
     * Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for
     * variable-names in the template will be replaced with the variable values before being sent to SageMaker.
     * </p>
     * 
     * @return Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for
     *         variable-names in the template will be replaced with the variable values before being sent to SageMaker.
     */
    public String csvInputTemplate() {
        return csvInputTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isOpaque());
        hashCode = 31 * hashCode + Objects.hashCode(jsonInputTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(csvInputTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInputConfiguration)) {
            return false;
        }
        ModelInputConfiguration other = (ModelInputConfiguration) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(isOpaque(), other.isOpaque())
                && Objects.equals(jsonInputTemplate(), other.jsonInputTemplate())
                && Objects.equals(csvInputTemplate(), other.csvInputTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelInputConfiguration").add("Format", formatAsString()).add("IsOpaque", isOpaque())
                .add("JsonInputTemplate", jsonInputTemplate()).add("CsvInputTemplate", csvInputTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "isOpaque":
            return Optional.ofNullable(clazz.cast(isOpaque()));
        case "jsonInputTemplate":
            return Optional.ofNullable(clazz.cast(jsonInputTemplate()));
        case "csvInputTemplate":
            return Optional.ofNullable(clazz.cast(csvInputTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelInputConfiguration, T> g) {
        return obj -> g.apply((ModelInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInputConfiguration> {
        /**
         * <p>
         * The format of the model input configuration. The format differs depending on if it is passed through to
         * SageMaker or constructed by Amazon Fraud Detector.
         * </p>
         * 
         * @param format
         *        The format of the model input configuration. The format differs depending on if it is passed through
         *        to SageMaker or constructed by Amazon Fraud Detector.
         * @see ModelInputDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInputDataFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the model input configuration. The format differs depending on if it is passed through to
         * SageMaker or constructed by Amazon Fraud Detector.
         * </p>
         * 
         * @param format
         *        The format of the model input configuration. The format differs depending on if it is passed through
         *        to SageMaker or constructed by Amazon Fraud Detector.
         * @see ModelInputDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInputDataFormat
         */
        Builder format(ModelInputDataFormat format);

        /**
         * <p>
         * For an opaque-model, the input to the model will be a ByteBuffer blob provided in the getPrediction request,
         * and will be passed to SageMaker as-is. For non-opaque models, the input will be constructed by Amazon Fraud
         * Detector based on the model-configuration.
         * </p>
         * 
         * @param isOpaque
         *        For an opaque-model, the input to the model will be a ByteBuffer blob provided in the getPrediction
         *        request, and will be passed to SageMaker as-is. For non-opaque models, the input will be constructed
         *        by Amazon Fraud Detector based on the model-configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOpaque(Boolean isOpaque);

        /**
         * <p>
         * Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders for
         * variable names in the template will be replaced with the variable values before being sent to SageMaker.
         * </p>
         * 
         * @param jsonInputTemplate
         *        Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders
         *        for variable names in the template will be replaced with the variable values before being sent to
         *        SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonInputTemplate(String jsonInputTemplate);

        /**
         * <p>
         * Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for
         * variable-names in the template will be replaced with the variable values before being sent to SageMaker.
         * </p>
         * 
         * @param csvInputTemplate
         *        Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders
         *        for variable-names in the template will be replaced with the variable values before being sent to
         *        SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvInputTemplate(String csvInputTemplate);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private Boolean isOpaque;

        private String jsonInputTemplate;

        private String csvInputTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInputConfiguration model) {
            format(model.format);
            isOpaque(model.isOpaque);
            jsonInputTemplate(model.jsonInputTemplate);
            csvInputTemplate(model.csvInputTemplate);
        }

        public final String getFormatAsString() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ModelInputDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Boolean getIsOpaque() {
            return isOpaque;
        }

        @Override
        public final Builder isOpaque(Boolean isOpaque) {
            this.isOpaque = isOpaque;
            return this;
        }

        public final void setIsOpaque(Boolean isOpaque) {
            this.isOpaque = isOpaque;
        }

        public final String getJsonInputTemplate() {
            return jsonInputTemplate;
        }

        @Override
        public final Builder jsonInputTemplate(String jsonInputTemplate) {
            this.jsonInputTemplate = jsonInputTemplate;
            return this;
        }

        public final void setJsonInputTemplate(String jsonInputTemplate) {
            this.jsonInputTemplate = jsonInputTemplate;
        }

        public final String getCsvInputTemplate() {
            return csvInputTemplate;
        }

        @Override
        public final Builder csvInputTemplate(String csvInputTemplate) {
            this.csvInputTemplate = csvInputTemplate;
            return this;
        }

        public final void setCsvInputTemplate(String csvInputTemplate) {
            this.csvInputTemplate = csvInputTemplate;
        }

        @Override
        public ModelInputConfiguration build() {
            return new ModelInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
