/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPredictionRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<GetPredictionRequest.Builder, GetPredictionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPredictionRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPredictionRequest::detectorVersionId)).setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPredictionRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<Map<String, String>> EVENT_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetPredictionRequest::eventAttributes))
            .setter(setter(Builder::eventAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ModelEndpointDataBlob>> EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD = SdkField
            .<Map<String, ModelEndpointDataBlob>> builder(MarshallingType.MAP)
            .getter(getter(GetPredictionRequest::externalModelEndpointDataBlobs))
            .setter(setter(Builder::externalModelEndpointDataBlobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpointDataBlobs")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ModelEndpointDataBlob> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelEndpointDataBlob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DETECTOR_VERSION_ID_FIELD, EVENT_ID_FIELD, EVENT_ATTRIBUTES_FIELD, EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD));

    private final String detectorId;

    private final String detectorVersionId;

    private final String eventId;

    private final Map<String, String> eventAttributes;

    private final Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs;

    private GetPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.eventId = builder.eventId;
        this.eventAttributes = builder.eventAttributes;
        this.externalModelEndpointDataBlobs = builder.externalModelEndpointDataBlobs;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public String detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * <p>
     * The unique ID used to identify the event.
     * </p>
     * 
     * @return The unique ID used to identify the event.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * Returns true if the EventAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventAttributes() {
        return eventAttributes != null && !(eventAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Names of variables you defined in Amazon Fraud Detector to represent event data elements and their corresponding
     * values for the event you are sending for evaluation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Names of variables you defined in Amazon Fraud Detector to represent event data elements and their
     *         corresponding values for the event you are sending for evaluation.
     */
    public Map<String, String> eventAttributes() {
        return eventAttributes;
    }

    /**
     * Returns true if the ExternalModelEndpointDataBlobs property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasExternalModelEndpointDataBlobs() {
        return externalModelEndpointDataBlobs != null && !(externalModelEndpointDataBlobs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Amazon SageMaker model endpoint input data blobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExternalModelEndpointDataBlobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon SageMaker model endpoint input data blobs.
     */
    public Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs() {
        return externalModelEndpointDataBlobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(externalModelEndpointDataBlobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPredictionRequest)) {
            return false;
        }
        GetPredictionRequest other = (GetPredictionRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(eventAttributes(), other.eventAttributes())
                && Objects.equals(externalModelEndpointDataBlobs(), other.externalModelEndpointDataBlobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("GetPredictionRequest")
                .add("DetectorId", detectorId())
                .add("DetectorVersionId", detectorVersionId())
                .add("EventId", eventId())
                .add("EventAttributes", eventAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExternalModelEndpointDataBlobs",
                        externalModelEndpointDataBlobs() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventAttributes":
            return Optional.ofNullable(clazz.cast(eventAttributes()));
        case "externalModelEndpointDataBlobs":
            return Optional.ofNullable(clazz.cast(externalModelEndpointDataBlobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPredictionRequest, T> g) {
        return obj -> g.apply((GetPredictionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPredictionRequest> {
        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);

        /**
         * <p>
         * The unique ID used to identify the event.
         * </p>
         * 
         * @param eventId
         *        The unique ID used to identify the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * Names of variables you defined in Amazon Fraud Detector to represent event data elements and their
         * corresponding values for the event you are sending for evaluation.
         * </p>
         * 
         * @param eventAttributes
         *        Names of variables you defined in Amazon Fraud Detector to represent event data elements and their
         *        corresponding values for the event you are sending for evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventAttributes(Map<String, String> eventAttributes);

        /**
         * <p>
         * The Amazon SageMaker model endpoint input data blobs.
         * </p>
         * 
         * @param externalModelEndpointDataBlobs
         *        The Amazon SageMaker model endpoint input data blobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String detectorVersionId;

        private String eventId;

        private Map<String, String> eventAttributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPredictionRequest model) {
            super(model);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            eventId(model.eventId);
            eventAttributes(model.eventAttributes);
            externalModelEndpointDataBlobs(model.externalModelEndpointDataBlobs);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final Map<String, String> getEventAttributes() {
            return eventAttributes;
        }

        @Override
        public final Builder eventAttributes(Map<String, String> eventAttributes) {
            this.eventAttributes = EventAttributeMapCopier.copy(eventAttributes);
            return this;
        }

        public final void setEventAttributes(Map<String, String> eventAttributes) {
            this.eventAttributes = EventAttributeMapCopier.copy(eventAttributes);
        }

        public final Map<String, ModelEndpointDataBlob.Builder> getExternalModelEndpointDataBlobs() {
            return externalModelEndpointDataBlobs != null ? CollectionUtils.mapValues(externalModelEndpointDataBlobs,
                    ModelEndpointDataBlob::toBuilder) : null;
        }

        @Override
        public final Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier.copy(externalModelEndpointDataBlobs);
            return this;
        }

        public final void setExternalModelEndpointDataBlobs(
                Map<String, ModelEndpointDataBlob.BuilderImpl> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier
                    .copyFromBuilder(externalModelEndpointDataBlobs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPredictionRequest build() {
            return new GetPredictionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
