/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetModelsResponse.Builder, GetModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Model>> MODELS_FIELD = SdkField
            .<List<Model>> builder(MarshallingType.LIST)
            .getter(getter(GetModelsResponse::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Model> builder(MarshallingType.SDK_POJO)
                                            .constructor(Model::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, MODELS_FIELD));

    private final String nextToken;

    private final List<Model> models;

    private GetModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.models = builder.models;
    }

    /**
     * <p>
     * The next token for subsequent requests.
     * </p>
     * 
     * @return The next token for subsequent requests.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Models property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The returned models.
     */
    public List<Model> models() {
        return models;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(models());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelsResponse)) {
            return false;
        }
        GetModelsResponse other = (GetModelsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(models(), other.models());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetModelsResponse").add("NextToken", nextToken()).add("Models", models()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelsResponse, T> g) {
        return obj -> g.apply((GetModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetModelsResponse> {
        /**
         * <p>
         * The next token for subsequent requests.
         * </p>
         * 
         * @param nextToken
         *        The next token for subsequent requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The returned models.
         * </p>
         * 
         * @param models
         *        The returned models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<Model> models);

        /**
         * <p>
         * The returned models.
         * </p>
         * 
         * @param models
         *        The returned models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Model... models);

        /**
         * <p>
         * The returned models.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Model>.Builder} avoiding the need to create
         * one manually via {@link List<Model>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Model>.Builder#build()} is called immediately and its result
         * is passed to {@link #models(List<Model>)}.
         * 
         * @param models
         *        a consumer that will call methods on {@link List<Model>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(List<Model>)
         */
        Builder models(Consumer<Model.Builder>... models);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Model> models = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelsResponse model) {
            super(model);
            nextToken(model.nextToken);
            models(model.models);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Model.Builder> getModels() {
            return models != null ? models.stream().map(Model::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder models(Collection<Model> models) {
            this.models = ModelListCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Model... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<Model.Builder>... models) {
            models(Stream.of(models).map(c -> Model.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<Model.BuilderImpl> models) {
            this.models = ModelListCopier.copyFromBuilder(models);
        }

        @Override
        public GetModelsResponse build() {
            return new GetModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
