/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDetectorsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetDetectorsResponse.Builder, GetDetectorsResponse> {
    private static final SdkField<List<Detector>> DETECTORS_FIELD = SdkField
            .<List<Detector>> builder(MarshallingType.LIST)
            .getter(getter(GetDetectorsResponse::detectors))
            .setter(setter(Builder::detectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Detector> builder(MarshallingType.SDK_POJO)
                                            .constructor(Detector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDetectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Detector> detectors;

    private final String nextToken;

    private GetDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.detectors = builder.detectors;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Detectors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDetectors() {
        return detectors != null && !(detectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The detectors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The detectors.
     */
    public List<Detector> detectors() {
        return detectors;
    }

    /**
     * <p>
     * The next page token.
     * </p>
     * 
     * @return The next page token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectors());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorsResponse)) {
            return false;
        }
        GetDetectorsResponse other = (GetDetectorsResponse) obj;
        return Objects.equals(detectors(), other.detectors()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDetectorsResponse").add("Detectors", detectors()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectors":
            return Optional.ofNullable(clazz.cast(detectors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDetectorsResponse, T> g) {
        return obj -> g.apply((GetDetectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDetectorsResponse> {
        /**
         * <p>
         * The detectors.
         * </p>
         * 
         * @param detectors
         *        The detectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectors(Collection<Detector> detectors);

        /**
         * <p>
         * The detectors.
         * </p>
         * 
         * @param detectors
         *        The detectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectors(Detector... detectors);

        /**
         * <p>
         * The detectors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Detector>.Builder} avoiding the need to
         * create one manually via {@link List<Detector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Detector>.Builder#build()} is called immediately and its
         * result is passed to {@link #detectors(List<Detector>)}.
         * 
         * @param detectors
         *        a consumer that will call methods on {@link List<Detector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectors(List<Detector>)
         */
        Builder detectors(Consumer<Detector.Builder>... detectors);

        /**
         * <p>
         * The next page token.
         * </p>
         * 
         * @param nextToken
         *        The next page token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<Detector> detectors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorsResponse model) {
            super(model);
            detectors(model.detectors);
            nextToken(model.nextToken);
        }

        public final Collection<Detector.Builder> getDetectors() {
            return detectors != null ? detectors.stream().map(Detector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectors(Collection<Detector> detectors) {
            this.detectors = DetectorListCopier.copy(detectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(Detector... detectors) {
            detectors(Arrays.asList(detectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(Consumer<Detector.Builder>... detectors) {
            detectors(Stream.of(detectors).map(c -> Detector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectors(Collection<Detector.BuilderImpl> detectors) {
            this.detectors = DetectorListCopier.copyFromBuilder(detectors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDetectorsResponse build() {
            return new GetDetectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
