/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelVersionsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<DescribeModelVersionsResponse.Builder, DescribeModelVersionsResponse> {
    private static final SdkField<List<ModelVersionDetail>> MODEL_VERSION_DETAILS_FIELD = SdkField
            .<List<ModelVersionDetail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeModelVersionsResponse::modelVersionDetails))
            .setter(setter(Builder::modelVersionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVersionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVersionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeModelVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ModelVersionDetail> modelVersionDetails;

    private final String nextToken;

    private DescribeModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.modelVersionDetails = builder.modelVersionDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ModelVersionDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasModelVersionDetails() {
        return modelVersionDetails != null && !(modelVersionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model version details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModelVersionDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model version details.
     */
    public List<ModelVersionDetail> modelVersionDetails() {
        return modelVersionDetails;
    }

    /**
     * <p>
     * The next token.
     * </p>
     * 
     * @return The next token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelVersionsResponse)) {
            return false;
        }
        DescribeModelVersionsResponse other = (DescribeModelVersionsResponse) obj;
        return Objects.equals(modelVersionDetails(), other.modelVersionDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeModelVersionsResponse").add("ModelVersionDetails", modelVersionDetails())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelVersionDetails":
            return Optional.ofNullable(clazz.cast(modelVersionDetails()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelVersionsResponse, T> g) {
        return obj -> g.apply((DescribeModelVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelVersionsResponse> {
        /**
         * <p>
         * The model version details.
         * </p>
         * 
         * @param modelVersionDetails
         *        The model version details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionDetails(Collection<ModelVersionDetail> modelVersionDetails);

        /**
         * <p>
         * The model version details.
         * </p>
         * 
         * @param modelVersionDetails
         *        The model version details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionDetails(ModelVersionDetail... modelVersionDetails);

        /**
         * <p>
         * The model version details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelVersionDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ModelVersionDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelVersionDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #modelVersionDetails(List<ModelVersionDetail>)}.
         * 
         * @param modelVersionDetails
         *        a consumer that will call methods on {@link List<ModelVersionDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVersionDetails(List<ModelVersionDetail>)
         */
        Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder>... modelVersionDetails);

        /**
         * <p>
         * The next token.
         * </p>
         * 
         * @param nextToken
         *        The next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<ModelVersionDetail> modelVersionDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelVersionsResponse model) {
            super(model);
            modelVersionDetails(model.modelVersionDetails);
            nextToken(model.nextToken);
        }

        public final Collection<ModelVersionDetail.Builder> getModelVersionDetails() {
            return modelVersionDetails != null ? modelVersionDetails.stream().map(ModelVersionDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modelVersionDetails(Collection<ModelVersionDetail> modelVersionDetails) {
            this.modelVersionDetails = ModelVersionDetailListCopier.copy(modelVersionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(ModelVersionDetail... modelVersionDetails) {
            modelVersionDetails(Arrays.asList(modelVersionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder>... modelVersionDetails) {
            modelVersionDetails(Stream.of(modelVersionDetails).map(c -> ModelVersionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModelVersionDetails(Collection<ModelVersionDetail.BuilderImpl> modelVersionDetails) {
            this.modelVersionDetails = ModelVersionDetailListCopier.copyFromBuilder(modelVersionDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeModelVersionsResponse build() {
            return new DescribeModelVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
