/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDetectorVersionRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<CreateDetectorVersionRequest.Builder, CreateDetectorVersionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDetectorVersionRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDetectorVersionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EXTERNAL_MODEL_ENDPOINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDetectorVersionRequest::externalModelEndpoints))
            .setter(setter(Builder::externalModelEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .getter(getter(CreateDetectorVersionRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ModelVersion>> MODEL_VERSIONS_FIELD = SdkField
            .<List<ModelVersion>> builder(MarshallingType.LIST)
            .getter(getter(CreateDetectorVersionRequest::modelVersions))
            .setter(setter(Builder::modelVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DESCRIPTION_FIELD, EXTERNAL_MODEL_ENDPOINTS_FIELD, RULES_FIELD, MODEL_VERSIONS_FIELD));

    private final String detectorId;

    private final String description;

    private final List<String> externalModelEndpoints;

    private final List<Rule> rules;

    private final List<ModelVersion> modelVersions;

    private CreateDetectorVersionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.description = builder.description;
        this.externalModelEndpoints = builder.externalModelEndpoints;
        this.rules = builder.rules;
        this.modelVersions = builder.modelVersions;
    }

    /**
     * <p>
     * The ID of the detector under which you want to create a new version.
     * </p>
     * 
     * @return The ID of the detector under which you want to create a new version.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The description of the detector version.
     * </p>
     * 
     * @return The description of the detector version.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the ExternalModelEndpoints property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExternalModelEndpoints() {
        return externalModelEndpoints != null && !(externalModelEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Sagemaker model endpoints to include in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExternalModelEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Sagemaker model endpoints to include in the detector version.
     */
    public List<String> externalModelEndpoints() {
        return externalModelEndpoints;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules to include in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rules to include in the detector version.
     */
    public List<Rule> rules() {
        return rules;
    }

    /**
     * Returns true if the ModelVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasModelVersions() {
        return modelVersions != null && !(modelVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model versions to include in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModelVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model versions to include in the detector version.
     */
    public List<ModelVersion> modelVersions() {
        return modelVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(externalModelEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDetectorVersionRequest)) {
            return false;
        }
        CreateDetectorVersionRequest other = (CreateDetectorVersionRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(description(), other.description())
                && Objects.equals(externalModelEndpoints(), other.externalModelEndpoints())
                && Objects.equals(rules(), other.rules()) && Objects.equals(modelVersions(), other.modelVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDetectorVersionRequest").add("DetectorId", detectorId()).add("Description", description())
                .add("ExternalModelEndpoints", externalModelEndpoints()).add("Rules", rules())
                .add("ModelVersions", modelVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "externalModelEndpoints":
            return Optional.ofNullable(clazz.cast(externalModelEndpoints()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "modelVersions":
            return Optional.ofNullable(clazz.cast(modelVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDetectorVersionRequest, T> g) {
        return obj -> g.apply((CreateDetectorVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDetectorVersionRequest> {
        /**
         * <p>
         * The ID of the detector under which you want to create a new version.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector under which you want to create a new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The description of the detector version.
         * </p>
         * 
         * @param description
         *        The description of the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Sagemaker model endpoints to include in the detector version.
         * </p>
         * 
         * @param externalModelEndpoints
         *        The Amazon Sagemaker model endpoints to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpoints(Collection<String> externalModelEndpoints);

        /**
         * <p>
         * The Amazon Sagemaker model endpoints to include in the detector version.
         * </p>
         * 
         * @param externalModelEndpoints
         *        The Amazon Sagemaker model endpoints to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpoints(String... externalModelEndpoints);

        /**
         * <p>
         * The rules to include in the detector version.
         * </p>
         * 
         * @param rules
         *        The rules to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * The rules to include in the detector version.
         * </p>
         * 
         * @param rules
         *        The rules to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * The rules to include in the detector version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Rule>.Builder} avoiding the need to create
         * one manually via {@link List<Rule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Rule>.Builder#build()} is called immediately and its result
         * is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<Rule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * The model versions to include in the detector version.
         * </p>
         * 
         * @param modelVersions
         *        The model versions to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersions(Collection<ModelVersion> modelVersions);

        /**
         * <p>
         * The model versions to include in the detector version.
         * </p>
         * 
         * @param modelVersions
         *        The model versions to include in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersions(ModelVersion... modelVersions);

        /**
         * <p>
         * The model versions to include in the detector version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelVersion>.Builder} avoiding the need to
         * create one manually via {@link List<ModelVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelVersion>.Builder#build()} is called immediately and its
         * result is passed to {@link #modelVersions(List<ModelVersion>)}.
         * 
         * @param modelVersions
         *        a consumer that will call methods on {@link List<ModelVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVersions(List<ModelVersion>)
         */
        Builder modelVersions(Consumer<ModelVersion.Builder>... modelVersions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String description;

        private List<String> externalModelEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private List<ModelVersion> modelVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDetectorVersionRequest model) {
            super(model);
            detectorId(model.detectorId);
            description(model.description);
            externalModelEndpoints(model.externalModelEndpoints);
            rules(model.rules);
            modelVersions(model.modelVersions);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getExternalModelEndpoints() {
            return externalModelEndpoints;
        }

        @Override
        public final Builder externalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModelEndpoints(String... externalModelEndpoints) {
            externalModelEndpoints(Arrays.asList(externalModelEndpoints));
            return this;
        }

        public final void setExternalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
        }

        public final Collection<Rule.Builder> getRules() {
            return rules != null ? rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        public final Collection<ModelVersion.Builder> getModelVersions() {
            return modelVersions != null ? modelVersions.stream().map(ModelVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder modelVersions(Collection<ModelVersion> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copy(modelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(ModelVersion... modelVersions) {
            modelVersions(Arrays.asList(modelVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(Consumer<ModelVersion.Builder>... modelVersions) {
            modelVersions(Stream.of(modelVersions).map(c -> ModelVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModelVersions(Collection<ModelVersion.BuilderImpl> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copyFromBuilder(modelVersions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDetectorVersionRequest build() {
            return new CreateDetectorVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
