/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateVariableRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<BatchCreateVariableRequest.Builder, BatchCreateVariableRequest> {
    private static final SdkField<List<VariableEntry>> VARIABLE_ENTRIES_FIELD = SdkField
            .<List<VariableEntry>> builder(MarshallingType.LIST)
            .getter(getter(BatchCreateVariableRequest::variableEntries))
            .setter(setter(Builder::variableEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariableEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariableEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_ENTRIES_FIELD));

    private final List<VariableEntry> variableEntries;

    private BatchCreateVariableRequest(BuilderImpl builder) {
        super(builder);
        this.variableEntries = builder.variableEntries;
    }

    /**
     * Returns true if the VariableEntries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVariableEntries() {
        return variableEntries != null && !(variableEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of variables for the batch create variable request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariableEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of variables for the batch create variable request.
     */
    public List<VariableEntry> variableEntries() {
        return variableEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(variableEntries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateVariableRequest)) {
            return false;
        }
        BatchCreateVariableRequest other = (BatchCreateVariableRequest) obj;
        return Objects.equals(variableEntries(), other.variableEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchCreateVariableRequest").add("VariableEntries", variableEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variableEntries":
            return Optional.ofNullable(clazz.cast(variableEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateVariableRequest, T> g) {
        return obj -> g.apply((BatchCreateVariableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchCreateVariableRequest> {
        /**
         * <p>
         * The list of variables for the batch create variable request.
         * </p>
         * 
         * @param variableEntries
         *        The list of variables for the batch create variable request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableEntries(Collection<VariableEntry> variableEntries);

        /**
         * <p>
         * The list of variables for the batch create variable request.
         * </p>
         * 
         * @param variableEntries
         *        The list of variables for the batch create variable request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableEntries(VariableEntry... variableEntries);

        /**
         * <p>
         * The list of variables for the batch create variable request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VariableEntry>.Builder} avoiding the need
         * to create one manually via {@link List<VariableEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VariableEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #variableEntries(List<VariableEntry>)}.
         * 
         * @param variableEntries
         *        a consumer that will call methods on {@link List<VariableEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variableEntries(List<VariableEntry>)
         */
        Builder variableEntries(Consumer<VariableEntry.Builder>... variableEntries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private List<VariableEntry> variableEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateVariableRequest model) {
            super(model);
            variableEntries(model.variableEntries);
        }

        public final Collection<VariableEntry.Builder> getVariableEntries() {
            return variableEntries != null ? variableEntries.stream().map(VariableEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder variableEntries(Collection<VariableEntry> variableEntries) {
            this.variableEntries = VariableEntryListCopier.copy(variableEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableEntries(VariableEntry... variableEntries) {
            variableEntries(Arrays.asList(variableEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableEntries(Consumer<VariableEntry.Builder>... variableEntries) {
            variableEntries(Stream.of(variableEntries).map(c -> VariableEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVariableEntries(Collection<VariableEntry.BuilderImpl> variableEntries) {
            this.variableEntries = VariableEntryListCopier.copyFromBuilder(variableEntries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateVariableRequest build() {
            return new BatchCreateVariableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
