/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetPredictionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetPredictionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableResponse;
import software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher;

/**
 * Service client for accessing Amazon Fraud Detector asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * This is the Amazon Fraud Detector API Reference. This guide is for developers who need detailed information about
 * Amazon Fraud Detector API actions, data types, and errors. For more information about Amazon Fraud Detector features,
 * see the <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/">Amazon Fraud Detector User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface FraudDetectorAsyncClient extends SdkClient {
    String SERVICE_NAME = "frauddetector";

    /**
     * Create a {@link FraudDetectorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FraudDetectorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FraudDetectorAsyncClient}.
     */
    static FraudDetectorAsyncClientBuilder builder() {
        return new DefaultFraudDetectorAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     *
     * @param batchCreateVariableRequest
     * @return A Java Future containing the result of the BatchCreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchCreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateVariableResponse> batchCreateVariable(
            BatchCreateVariableRequest batchCreateVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateVariableRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateVariableRequest#builder()}
     * </p>
     *
     * @param batchCreateVariableRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateVariableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchCreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateVariableResponse> batchCreateVariable(
            Consumer<BatchCreateVariableRequest.Builder> batchCreateVariableRequest) {
        return batchCreateVariable(BatchCreateVariableRequest.builder().applyMutation(batchCreateVariableRequest).build());
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     *
     * @param batchGetVariableRequest
     * @return A Java Future containing the result of the BatchGetVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchGetVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetVariableResponse> batchGetVariable(BatchGetVariableRequest batchGetVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetVariableRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetVariableRequest#builder()}
     * </p>
     *
     * @param batchGetVariableRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetVariableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchGetVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetVariableResponse> batchGetVariable(
            Consumer<BatchGetVariableRequest.Builder> batchGetVariableRequest) {
        return batchGetVariable(BatchGetVariableRequest.builder().applyMutation(batchGetVariableRequest).build());
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     *
     * @param createDetectorVersionRequest
     * @return A Java Future containing the result of the CreateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDetectorVersionResponse> createDetectorVersion(
            CreateDetectorVersionRequest createDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDetectorVersionRequest#builder()}
     * </p>
     *
     * @param createDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDetectorVersionResponse> createDetectorVersion(
            Consumer<CreateDetectorVersionRequest.Builder> createDetectorVersionRequest) {
        return createDetectorVersion(CreateDetectorVersionRequest.builder().applyMutation(createDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type.
     * </p>
     *
     * @param createModelVersionRequest
     * @return A Java Future containing the result of the CreateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelVersionResponse> createModelVersion(CreateModelVersionRequest createModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelVersionRequest#builder()}
     * </p>
     *
     * @param createModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelVersionResponse> createModelVersion(
            Consumer<CreateModelVersionRequest.Builder> createModelVersionRequest) {
        return createModelVersion(CreateModelVersionRequest.builder().applyMutation(createModelVersionRequest).build());
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     *
     * @param createVariableRequest
     * @return A Java Future containing the result of the CreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVariableResponse> createVariable(CreateVariableRequest createVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVariableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVariableRequest#builder()}
     * </p>
     *
     * @param createVariableRequest
     *        A {@link Consumer} that will call methods on {@link CreateVariableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVariableResponse> createVariable(Consumer<CreateVariableRequest.Builder> createVariableRequest) {
        return createVariable(CreateVariableRequest.builder().applyMutation(createVariableRequest).build());
    }

    /**
     * <p>
     * Deletes the detector version.
     * </p>
     *
     * @param deleteDetectorVersionRequest
     * @return A Java Future containing the result of the DeleteDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorVersionResponse> deleteDetectorVersion(
            DeleteDetectorVersionRequest deleteDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the detector version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDetectorVersionRequest#builder()}
     * </p>
     *
     * @param deleteDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorVersionResponse> deleteDetectorVersion(
            Consumer<DeleteDetectorVersionRequest.Builder> deleteDetectorVersionRequest) {
        return deleteDetectorVersion(DeleteDetectorVersionRequest.builder().applyMutation(deleteDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     *
     * @param deleteEventRequest
     * @return A Java Future containing the result of the DeleteEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEventResponse> deleteEvent(DeleteEventRequest deleteEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEventRequest#builder()}
     * </p>
     *
     * @param deleteEventRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEventResponse> deleteEvent(Consumer<DeleteEventRequest.Builder> deleteEventRequest) {
        return deleteEvent(DeleteEventRequest.builder().applyMutation(deleteEventRequest).build());
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     *
     * @param describeDetectorRequest
     * @return A Java Future containing the result of the DescribeDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorResponse> describeDetector(DescribeDetectorRequest describeDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDetectorRequest#builder()}
     * </p>
     *
     * @param describeDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorResponse> describeDetector(
            Consumer<DescribeDetectorRequest.Builder> describeDetectorRequest) {
        return describeDetector(DescribeDetectorRequest.builder().applyMutation(describeDetectorRequest).build());
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return A Java Future containing the result of the DescribeModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelVersionsResponse> describeModelVersions(
            DescribeModelVersionsRequest describeModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionsRequest#builder()}
     * </p>
     *
     * @param describeModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelVersionsResponse> describeModelVersions(
            Consumer<DescribeModelVersionsRequest.Builder> describeModelVersionsRequest) {
        return describeModelVersions(DescribeModelVersionsRequest.builder().applyMutation(describeModelVersionsRequest).build());
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsPublisher describeModelVersionsPaginator(
            DescribeModelVersionsRequest describeModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionsRequest#builder()}
     * </p>
     *
     * @param describeModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsPublisher describeModelVersionsPaginator(
            Consumer<DescribeModelVersionsRequest.Builder> describeModelVersionsRequest) {
        return describeModelVersionsPaginator(DescribeModelVersionsRequest.builder().applyMutation(describeModelVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     *
     * @param getDetectorVersionRequest
     * @return A Java Future containing the result of the GetDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDetectorVersionResponse> getDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetDetectorVersionRequest#builder()}
     * </p>
     *
     * @param getDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDetectorVersionResponse> getDetectorVersion(
            Consumer<GetDetectorVersionRequest.Builder> getDetectorVersionRequest) {
        return getDetectorVersion(GetDetectorVersionRequest.builder().applyMutation(getDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Gets all of detectors. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this actions
     * retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must be
     * between 5 and 10. To get the next page results, provide the pagination token from the
     * <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param getDetectorsRequest
     * @return A Java Future containing the result of the GetDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDetectorsResponse> getDetectors(GetDetectorsRequest getDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of detectors. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this actions
     * retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must be
     * between 5 and 10. To get the next page results, provide the pagination token from the
     * <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorsRequest#builder()}
     * </p>
     *
     * @param getDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDetectorsResponse> getDetectors(Consumer<GetDetectorsRequest.Builder> getDetectorsRequest) {
        return getDetectors(GetDetectorsRequest.builder().applyMutation(getDetectorsRequest).build());
    }

    /**
     * <p>
     * Gets all of detectors. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this actions
     * retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must be
     * between 5 and 10. To get the next page results, provide the pagination token from the
     * <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation.</b>
     * </p>
     *
     * @param getDetectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorsPublisher getDetectorsPaginator(GetDetectorsRequest getDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of detectors. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this actions
     * retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must be
     * between 5 and 10. To get the next page results, provide the pagination token from the
     * <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorsRequest#builder()}
     * </p>
     *
     * @param getDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorsPublisher getDetectorsPaginator(Consumer<GetDetectorsRequest.Builder> getDetectorsRequest) {
        return getDetectorsPaginator(GetDetectorsRequest.builder().applyMutation(getDetectorsRequest).build());
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxSizePerPage</code>, this actions retrieves a maximum of 10 records
     * per page. If you provide a <code>maxSizePerPage</code>, the value must be between 5 and 10. To get the next page
     * results, provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A
     * null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getExternalModelsRequest
     * @return A Java Future containing the result of the GetExternalModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExternalModelsResponse> getExternalModels(GetExternalModelsRequest getExternalModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxSizePerPage</code>, this actions retrieves a maximum of 10 records
     * per page. If you provide a <code>maxSizePerPage</code>, the value must be between 5 and 10. To get the next page
     * results, provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A
     * null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExternalModelsRequest.Builder} avoiding the need
     * to create one manually via {@link GetExternalModelsRequest#builder()}
     * </p>
     *
     * @param getExternalModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetExternalModelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExternalModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExternalModelsResponse> getExternalModels(
            Consumer<GetExternalModelsRequest.Builder> getExternalModelsRequest) {
        return getExternalModels(GetExternalModelsRequest.builder().applyMutation(getExternalModelsRequest).build());
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxSizePerPage</code>, this actions retrieves a maximum of 10 records
     * per page. If you provide a <code>maxSizePerPage</code>, the value must be between 5 and 10. To get the next page
     * results, provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A
     * null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getExternalModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsPublisher getExternalModelsPaginator(GetExternalModelsRequest getExternalModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxSizePerPage</code>, this actions retrieves a maximum of 10 records
     * per page. If you provide a <code>maxSizePerPage</code>, the value must be between 5 and 10. To get the next page
     * results, provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A
     * null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExternalModelsRequest.Builder} avoiding the need
     * to create one manually via {@link GetExternalModelsRequest#builder()}
     * </p>
     *
     * @param getExternalModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetExternalModelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsPublisher getExternalModelsPaginator(
            Consumer<GetExternalModelsRequest.Builder> getExternalModelsRequest) {
        return getExternalModelsPaginator(GetExternalModelsRequest.builder().applyMutation(getExternalModelsRequest).build());
    }

    /**
     * <p>
     * Gets a model version.
     * </p>
     *
     * @param getModelVersionRequest
     * @return A Java Future containing the result of the GetModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelVersionResponse> getModelVersion(GetModelVersionRequest getModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelVersionRequest#builder()}
     * </p>
     *
     * @param getModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetModelVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelVersionResponse> getModelVersion(
            Consumer<GetModelVersionRequest.Builder> getModelVersionRequest) {
        return getModelVersion(GetModelVersionRequest.builder().applyMutation(getModelVersionRequest).build());
    }

    /**
     * <p>
     * Gets all of the models for the AWS account, or the specified model type, or gets a single model for the specified
     * model type, model ID combination.
     * </p>
     *
     * @param getModelsRequest
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelsResponse> getModels(GetModelsRequest getModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the models for the AWS account, or the specified model type, or gets a single model for the specified
     * model type, model ID combination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelsResponse> getModels(Consumer<GetModelsRequest.Builder> getModelsRequest) {
        return getModels(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets all of the models for the AWS account, or the specified model type, or gets a single model for the specified
     * model type, model ID combination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)} operation.</b>
     * </p>
     *
     * @param getModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsPublisher getModelsPaginator(GetModelsRequest getModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the models for the AWS account, or the specified model type, or gets a single model for the specified
     * model type, model ID combination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsPublisher getModelsPaginator(Consumer<GetModelsRequest.Builder> getModelsRequest) {
        return getModelsPaginator(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this
     * actions retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must
     * be between 50 and 100. To get the next page results, provide the pagination token from the
     * <code>GetOutcomesResult</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param getOutcomesRequest
     * @return A Java Future containing the result of the GetOutcomes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOutcomesResponse> getOutcomes(GetOutcomesRequest getOutcomesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this
     * actions retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must
     * be between 50 and 100. To get the next page results, provide the pagination token from the
     * <code>GetOutcomesResult</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutcomesRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutcomesRequest#builder()}
     * </p>
     *
     * @param getOutcomesRequest
     *        A {@link Consumer} that will call methods on {@link GetOutcomesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOutcomes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOutcomesResponse> getOutcomes(Consumer<GetOutcomesRequest.Builder> getOutcomesRequest) {
        return getOutcomes(GetOutcomesRequest.builder().applyMutation(getOutcomesRequest).build());
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this
     * actions retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must
     * be between 50 and 100. To get the next page results, provide the pagination token from the
     * <code>GetOutcomesResult</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)} operation.</b>
     * </p>
     *
     * @param getOutcomesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesPublisher getOutcomesPaginator(GetOutcomesRequest getOutcomesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxSizePerPage</code>, this
     * actions retrieves a maximum of 10 records per page. If you provide a <code>maxSizePerPage</code>, the value must
     * be between 50 and 100. To get the next page results, provide the pagination token from the
     * <code>GetOutcomesResult</code> as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutcomesRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutcomesRequest#builder()}
     * </p>
     *
     * @param getOutcomesRequest
     *        A {@link Consumer} that will call methods on {@link GetOutcomesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesPublisher getOutcomesPaginator(Consumer<GetOutcomesRequest.Builder> getOutcomesRequest) {
        return getOutcomesPaginator(GetOutcomesRequest.builder().applyMutation(getOutcomesRequest).build());
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     *
     * @param getPredictionRequest
     * @return A Java Future containing the result of the GetPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetPrediction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetPrediction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPredictionResponse> getPrediction(GetPredictionRequest getPredictionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPredictionRequest.Builder} avoiding the need to
     * create one manually via {@link GetPredictionRequest#builder()}
     * </p>
     *
     * @param getPredictionRequest
     *        A {@link Consumer} that will call methods on {@link GetPredictionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetPrediction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetPrediction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPredictionResponse> getPrediction(Consumer<GetPredictionRequest.Builder> getPredictionRequest) {
        return getPrediction(GetPredictionRequest.builder().applyMutation(getPredictionRequest).build());
    }

    /**
     * <p>
     * Gets all rules available for the specified detector.
     * </p>
     *
     * @param getRulesRequest
     * @return A Java Future containing the result of the GetRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRulesResponse> getRules(GetRulesRequest getRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all rules available for the specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRulesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRulesRequest#builder()}
     * </p>
     *
     * @param getRulesRequest
     *        A {@link Consumer} that will call methods on {@link GetRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRulesResponse> getRules(Consumer<GetRulesRequest.Builder> getRulesRequest) {
        return getRules(GetRulesRequest.builder().applyMutation(getRulesRequest).build());
    }

    /**
     * <p>
     * Gets all rules available for the specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)} operation.</b>
     * </p>
     *
     * @param getRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesPublisher getRulesPaginator(GetRulesRequest getRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all rules available for the specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRulesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRulesRequest#builder()}
     * </p>
     *
     * @param getRulesRequest
     *        A {@link Consumer} that will call methods on {@link GetRulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesPublisher getRulesPaginator(Consumer<GetRulesRequest.Builder> getRulesRequest) {
        return getRulesPaginator(GetRulesRequest.builder().applyMutation(getRulesRequest).build());
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getVariablesRequest
     * @return A Java Future containing the result of the GetVariables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariablesResponse> getVariables(GetVariablesRequest getVariablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetVariablesRequest#builder()}
     * </p>
     *
     * @param getVariablesRequest
     *        A {@link Consumer} that will call methods on {@link GetVariablesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVariables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariablesResponse> getVariables(Consumer<GetVariablesRequest.Builder> getVariablesRequest) {
        return getVariables(GetVariablesRequest.builder().applyMutation(getVariablesRequest).build());
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation.</b>
     * </p>
     *
     * @param getVariablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVariablesPublisher getVariablesPaginator(GetVariablesRequest getVariablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetVariablesRequest#builder()}
     * </p>
     *
     * @param getVariablesRequest
     *        A {@link Consumer} that will call methods on {@link GetVariablesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVariablesPublisher getVariablesPaginator(Consumer<GetVariablesRequest.Builder> getVariablesRequest) {
        return getVariablesPaginator(GetVariablesRequest.builder().applyMutation(getVariablesRequest).build());
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     *
     * @param putDetectorRequest
     * @return A Java Future containing the result of the PutDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDetectorResponse> putDetector(PutDetectorRequest putDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link PutDetectorRequest#builder()}
     * </p>
     *
     * @param putDetectorRequest
     *        A {@link Consumer} that will call methods on {@link PutDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDetectorResponse> putDetector(Consumer<PutDetectorRequest.Builder> putDetectorRequest) {
        return putDetector(PutDetectorRequest.builder().applyMutation(putDetectorRequest).build());
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     *
     * @param putExternalModelRequest
     * @return A Java Future containing the result of the PutExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutExternalModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutExternalModelResponse> putExternalModel(PutExternalModelRequest putExternalModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutExternalModelRequest.Builder} avoiding the need
     * to create one manually via {@link PutExternalModelRequest#builder()}
     * </p>
     *
     * @param putExternalModelRequest
     *        A {@link Consumer} that will call methods on {@link PutExternalModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutExternalModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutExternalModelResponse> putExternalModel(
            Consumer<PutExternalModelRequest.Builder> putExternalModelRequest) {
        return putExternalModel(PutExternalModelRequest.builder().applyMutation(putExternalModelRequest).build());
    }

    /**
     * <p>
     * Creates or updates a model.
     * </p>
     *
     * @param putModelRequest
     * @return A Java Future containing the result of the PutModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutModelResponse> putModel(PutModelRequest putModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutModelRequest.Builder} avoiding the need to
     * create one manually via {@link PutModelRequest#builder()}
     * </p>
     *
     * @param putModelRequest
     *        A {@link Consumer} that will call methods on {@link PutModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutModelResponse> putModel(Consumer<PutModelRequest.Builder> putModelRequest) {
        return putModel(PutModelRequest.builder().applyMutation(putModelRequest).build());
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     *
     * @param putOutcomeRequest
     * @return A Java Future containing the result of the PutOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutOutcome
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutOutcomeResponse> putOutcome(PutOutcomeRequest putOutcomeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOutcomeRequest.Builder} avoiding the need to
     * create one manually via {@link PutOutcomeRequest#builder()}
     * </p>
     *
     * @param putOutcomeRequest
     *        A {@link Consumer} that will call methods on {@link PutOutcomeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutOutcome
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutOutcomeResponse> putOutcome(Consumer<PutOutcomeRequest.Builder> putOutcomeRequest) {
        return putOutcome(PutOutcomeRequest.builder().applyMutation(putOutcomeRequest).build());
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, and description. You can only update a <code>DRAFT</code> detector version.
     * </p>
     *
     * @param updateDetectorVersionRequest
     * @return A Java Future containing the result of the UpdateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionResponse> updateDetectorVersion(
            UpdateDetectorVersionRequest updateDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, and description. You can only update a <code>DRAFT</code> detector version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDetectorVersionRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionResponse> updateDetectorVersion(
            Consumer<UpdateDetectorVersionRequest.Builder> updateDetectorVersionRequest) {
        return updateDetectorVersion(UpdateDetectorVersionRequest.builder().applyMutation(updateDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     * @return A Java Future containing the result of the UpdateDetectorVersionMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionMetadataResponse> updateDetectorVersionMetadata(
            UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDetectorVersionMetadataRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDetectorVersionMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionMetadataResponse> updateDetectorVersionMetadata(
            Consumer<UpdateDetectorVersionMetadataRequest.Builder> updateDetectorVersionMetadataRequest) {
        return updateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest.builder()
                .applyMutation(updateDetectorVersionMetadataRequest).build());
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     * @return A Java Future containing the result of the UpdateDetectorVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionStatusResponse> updateDetectorVersionStatus(
            UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDetectorVersionStatusRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionStatusRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateDetectorVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionStatusResponse> updateDetectorVersionStatus(
            Consumer<UpdateDetectorVersionStatusRequest.Builder> updateDetectorVersionStatusRequest) {
        return updateDetectorVersionStatus(UpdateDetectorVersionStatusRequest.builder()
                .applyMutation(updateDetectorVersionStatusRequest).build());
    }

    /**
     * <p>
     * Updates a model version. You can update the description and status attributes using this action. You can perform
     * the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code> back to <code>TRAINING_COMPLETE</code>
     * </p>
     * </li>
     * </ol>
     *
     * @param updateModelVersionRequest
     * @return A Java Future containing the result of the UpdateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelVersionResponse> updateModelVersion(UpdateModelVersionRequest updateModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a model version. You can update the description and status attributes using this action. You can perform
     * the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code> back to <code>TRAINING_COMPLETE</code>
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateModelVersionRequest#builder()}
     * </p>
     *
     * @param updateModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelVersionResponse> updateModelVersion(
            Consumer<UpdateModelVersionRequest.Builder> updateModelVersionRequest) {
        return updateModelVersion(UpdateModelVersionRequest.builder().applyMutation(updateModelVersionRequest).build());
    }

    /**
     * <p>
     * Updates a rule's metadata.
     * </p>
     *
     * @param updateRuleMetadataRequest
     * @return A Java Future containing the result of the UpdateRuleMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleMetadataResponse> updateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a rule's metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRuleMetadataRequest#builder()}
     * </p>
     *
     * @param updateRuleMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRuleMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleMetadataResponse> updateRuleMetadata(
            Consumer<UpdateRuleMetadataRequest.Builder> updateRuleMetadataRequest) {
        return updateRuleMetadata(UpdateRuleMetadataRequest.builder().applyMutation(updateRuleMetadataRequest).build());
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version.
     * </p>
     *
     * @param updateRuleVersionRequest
     * @return A Java Future containing the result of the UpdateRuleVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleVersionResponse> updateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleVersionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleVersionRequest#builder()}
     * </p>
     *
     * @param updateRuleVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRuleVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleVersionResponse> updateRuleVersion(
            Consumer<UpdateRuleVersionRequest.Builder> updateRuleVersionRequest) {
        return updateRuleVersion(UpdateRuleVersionRequest.builder().applyMutation(updateRuleVersionRequest).build());
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     *
     * @param updateVariableRequest
     * @return A Java Future containing the result of the UpdateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVariableResponse> updateVariable(UpdateVariableRequest updateVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVariableRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVariableRequest#builder()}
     * </p>
     *
     * @param updateVariableRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVariableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVariableResponse> updateVariable(Consumer<UpdateVariableRequest.Builder> updateVariableRequest) {
        return updateVariable(UpdateVariableRequest.builder().applyMutation(updateVariableRequest).build());
    }
}
