/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWhatIfForecastExportResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeWhatIfForecastExportResponse.Builder, DescribeWhatIfForecastExportResponse> {
    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastExportArn").getter(getter(DescribeWhatIfForecastExportResponse::whatIfForecastExportArn))
            .setter(setter(Builder::whatIfForecastExportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportArn").build())
            .build();

    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastExportName")
            .getter(getter(DescribeWhatIfForecastExportResponse::whatIfForecastExportName))
            .setter(setter(Builder::whatIfForecastExportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportName").build())
            .build();

    private static final SdkField<List<String>> WHAT_IF_FORECAST_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WhatIfForecastArns")
            .getter(getter(DescribeWhatIfForecastExportResponse::whatIfForecastArns))
            .setter(setter(Builder::whatIfForecastArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(DescribeWhatIfForecastExportResponse::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeWhatIfForecastExportResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeWhatIfForecastExportResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeWhatIfForecastExportResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribeWhatIfForecastExportResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeWhatIfForecastExportResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(DescribeWhatIfForecastExportResponse::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WHAT_IF_FORECAST_EXPORT_ARN_FIELD, WHAT_IF_FORECAST_EXPORT_NAME_FIELD, WHAT_IF_FORECAST_ARNS_FIELD,
            DESTINATION_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD,
            LAST_MODIFICATION_TIME_FIELD, FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String whatIfForecastExportArn;

    private final String whatIfForecastExportName;

    private final List<String> whatIfForecastArns;

    private final DataDestination destination;

    private final String message;

    private final String status;

    private final Instant creationTime;

    private final Long estimatedTimeRemainingInMinutes;

    private final Instant lastModificationTime;

    private final String format;

    private DescribeWhatIfForecastExportResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastExportArn = builder.whatIfForecastExportArn;
        this.whatIfForecastExportName = builder.whatIfForecastExportName;
        this.whatIfForecastArns = builder.whatIfForecastArns;
        this.destination = builder.destination;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.lastModificationTime = builder.lastModificationTime;
        this.format = builder.format;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if forecast export.
     */
    public final String whatIfForecastExportArn() {
        return whatIfForecastExportArn;
    }

    /**
     * <p>
     * The name of the what-if forecast export.
     * </p>
     * 
     * @return The name of the what-if forecast export.
     */
    public final String whatIfForecastExportName() {
        return whatIfForecastExportName;
    }

    /**
     * For responses, this returns true if the service returned a value for the WhatIfForecastArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWhatIfForecastArns() {
        return whatIfForecastArns != null && !(whatIfForecastArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWhatIfForecastArns} method.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
     *         resource.
     */
    public final List<String> whatIfForecastArns() {
        return whatIfForecastArns;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The status of the what-if forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access the
     * forecast export.
     * </p>
     * </note>
     * 
     * @return The status of the what-if forecast. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access
     *         the forecast export.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * When the what-if forecast export was created.
     * </p>
     * 
     * @return When the what-if forecast export was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The approximate time remaining to complete the what-if forecast export, in minutes.
     * </p>
     * 
     * @return The approximate time remaining to complete the what-if forecast export, in minutes.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The format of the exported data, CSV or PARQUET.
     * </p>
     * 
     * @return The format of the exported data, CSV or PARQUET.
     */
    public final String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastExportArn());
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastExportName());
        hashCode = 31 * hashCode + Objects.hashCode(hasWhatIfForecastArns() ? whatIfForecastArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWhatIfForecastExportResponse)) {
            return false;
        }
        DescribeWhatIfForecastExportResponse other = (DescribeWhatIfForecastExportResponse) obj;
        return Objects.equals(whatIfForecastExportArn(), other.whatIfForecastExportArn())
                && Objects.equals(whatIfForecastExportName(), other.whatIfForecastExportName())
                && hasWhatIfForecastArns() == other.hasWhatIfForecastArns()
                && Objects.equals(whatIfForecastArns(), other.whatIfForecastArns())
                && Objects.equals(destination(), other.destination()) && Objects.equals(message(), other.message())
                && Objects.equals(status(), other.status()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWhatIfForecastExportResponse").add("WhatIfForecastExportArn", whatIfForecastExportArn())
                .add("WhatIfForecastExportName", whatIfForecastExportName())
                .add("WhatIfForecastArns", hasWhatIfForecastArns() ? whatIfForecastArns() : null)
                .add("Destination", destination()).add("Message", message()).add("Status", status())
                .add("CreationTime", creationTime()).add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes())
                .add("LastModificationTime", lastModificationTime()).add("Format", format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecastExportArn":
            return Optional.ofNullable(clazz.cast(whatIfForecastExportArn()));
        case "WhatIfForecastExportName":
            return Optional.ofNullable(clazz.cast(whatIfForecastExportName()));
        case "WhatIfForecastArns":
            return Optional.ofNullable(clazz.cast(whatIfForecastArns()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WhatIfForecastExportArn", WHAT_IF_FORECAST_EXPORT_ARN_FIELD);
        map.put("WhatIfForecastExportName", WHAT_IF_FORECAST_EXPORT_NAME_FIELD);
        map.put("WhatIfForecastArns", WHAT_IF_FORECAST_ARNS_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWhatIfForecastExportResponse, T> g) {
        return obj -> g.apply((DescribeWhatIfForecastExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWhatIfForecastExportResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if forecast export.
         * </p>
         * 
         * @param whatIfForecastExportArn
         *        The Amazon Resource Name (ARN) of the what-if forecast export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExportArn(String whatIfForecastExportArn);

        /**
         * <p>
         * The name of the what-if forecast export.
         * </p>
         * 
         * @param whatIfForecastExportName
         *        The name of the what-if forecast export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExportName(String whatIfForecastExportName);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
         * resource.
         * </p>
         * 
         * @param whatIfForecastArns
         *        An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastArns(Collection<String> whatIfForecastArns);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
         * resource.
         * </p>
         * 
         * @param whatIfForecastArns
         *        An array of Amazon Resource Names (ARNs) that represent all of the what-if forecasts exported in this
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastArns(String... whatIfForecastArns);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataDestination.Builder} avoiding the
         * need to create one manually via {@link DataDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The status of the what-if forecast. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can access the
         * forecast export.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the what-if forecast. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the what-if forecast export must be <code>ACTIVE</code> before you can
         *        access the forecast export.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When the what-if forecast export was created.
         * </p>
         * 
         * @param creationTime
         *        When the what-if forecast export was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The approximate time remaining to complete the what-if forecast export, in minutes.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The approximate time remaining to complete the what-if forecast export, in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The format of the exported data, CSV or PARQUET.
         * </p>
         * 
         * @param format
         *        The format of the exported data, CSV or PARQUET.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String whatIfForecastExportArn;

        private String whatIfForecastExportName;

        private List<String> whatIfForecastArns = DefaultSdkAutoConstructList.getInstance();

        private DataDestination destination;

        private String message;

        private String status;

        private Instant creationTime;

        private Long estimatedTimeRemainingInMinutes;

        private Instant lastModificationTime;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWhatIfForecastExportResponse model) {
            super(model);
            whatIfForecastExportArn(model.whatIfForecastExportArn);
            whatIfForecastExportName(model.whatIfForecastExportName);
            whatIfForecastArns(model.whatIfForecastArns);
            destination(model.destination);
            message(model.message);
            status(model.status);
            creationTime(model.creationTime);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            lastModificationTime(model.lastModificationTime);
            format(model.format);
        }

        public final String getWhatIfForecastExportArn() {
            return whatIfForecastExportArn;
        }

        public final void setWhatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
        }

        @Override
        public final Builder whatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
            return this;
        }

        public final String getWhatIfForecastExportName() {
            return whatIfForecastExportName;
        }

        public final void setWhatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
        }

        @Override
        public final Builder whatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
            return this;
        }

        public final Collection<String> getWhatIfForecastArns() {
            if (whatIfForecastArns instanceof SdkAutoConstructList) {
                return null;
            }
            return whatIfForecastArns;
        }

        public final void setWhatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = LongArnListCopier.copy(whatIfForecastArns);
        }

        @Override
        public final Builder whatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = LongArnListCopier.copy(whatIfForecastArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecastArns(String... whatIfForecastArns) {
            whatIfForecastArns(Arrays.asList(whatIfForecastArns));
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public DescribeWhatIfForecastExportResponse build() {
            return new DescribeWhatIfForecastExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
