/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DayOfWeek;
import software.amazon.awssdk.services.forecast.model.Month;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeAlignmentBoundary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeAlignmentBoundary> {
    private static final SdkField<String> MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Month").getter(TimeAlignmentBoundary.getter(TimeAlignmentBoundary::monthAsString)).setter(TimeAlignmentBoundary.setter(Builder::month)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Month").build()}).build();
    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DayOfMonth").getter(TimeAlignmentBoundary.getter(TimeAlignmentBoundary::dayOfMonth)).setter(TimeAlignmentBoundary.setter(Builder::dayOfMonth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()}).build();
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DayOfWeek").getter(TimeAlignmentBoundary.getter(TimeAlignmentBoundary::dayOfWeekAsString)).setter(TimeAlignmentBoundary.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()}).build();
    private static final SdkField<Integer> HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Hour").getter(TimeAlignmentBoundary.getter(TimeAlignmentBoundary::hour)).setter(TimeAlignmentBoundary.setter(Builder::hour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTH_FIELD, DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD, HOUR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeAlignmentBoundary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String month;
    private final Integer dayOfMonth;
    private final String dayOfWeek;
    private final Integer hour;

    private TimeAlignmentBoundary(BuilderImpl builder) {
        this.month = builder.month;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.hour = builder.hour;
    }

    public final Month month() {
        return Month.fromValue(this.month);
    }

    public final String monthAsString() {
        return this.month;
    }

    public final Integer dayOfMonth() {
        return this.dayOfMonth;
    }

    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public final String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public final Integer hour() {
        return this.hour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeAlignmentBoundary)) {
            return false;
        }
        TimeAlignmentBoundary other = (TimeAlignmentBoundary)obj;
        return Objects.equals(this.monthAsString(), other.monthAsString()) && Objects.equals(this.dayOfMonth(), other.dayOfMonth()) && Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(this.hour(), other.hour());
    }

    public final String toString() {
        return ToString.builder((String)"TimeAlignmentBoundary").add("Month", (Object)this.monthAsString()).add("DayOfMonth", (Object)this.dayOfMonth()).add("DayOfWeek", (Object)this.dayOfWeekAsString()).add("Hour", (Object)this.hour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Month": {
                return Optional.ofNullable(clazz.cast(this.monthAsString()));
            }
            case "DayOfMonth": {
                return Optional.ofNullable(clazz.cast(this.dayOfMonth()));
            }
            case "DayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeekAsString()));
            }
            case "Hour": {
                return Optional.ofNullable(clazz.cast(this.hour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Month", MONTH_FIELD);
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("Hour", HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeAlignmentBoundary, T> g) {
        return obj -> g.apply((TimeAlignmentBoundary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String month;
        private Integer dayOfMonth;
        private String dayOfWeek;
        private Integer hour;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeAlignmentBoundary model) {
            this.month(model.month);
            this.dayOfMonth(model.dayOfMonth);
            this.dayOfWeek(model.dayOfWeek);
            this.hour(model.hour);
        }

        public final String getMonth() {
            return this.month;
        }

        public final void setMonth(String month) {
            this.month = month;
        }

        @Override
        public final Builder month(String month) {
            this.month = month;
            return this;
        }

        @Override
        public final Builder month(Month month) {
            this.month(month == null ? null : month.toString());
            return this;
        }

        public final Integer getDayOfMonth() {
            return this.dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getDayOfWeek() {
            return this.dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final Integer getHour() {
            return this.hour;
        }

        public final void setHour(Integer hour) {
            this.hour = hour;
        }

        @Override
        public final Builder hour(Integer hour) {
            this.hour = hour;
            return this;
        }

        public TimeAlignmentBoundary build() {
            return new TimeAlignmentBoundary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeAlignmentBoundary> {
        public Builder month(String var1);

        public Builder month(Month var1);

        public Builder dayOfMonth(Integer var1);

        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);

        public Builder hour(Integer var1);
    }
}

