/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitorDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitorDataSource> {
    private static final SdkField<String> DATASET_IMPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetImportJobArn").getter(MonitorDataSource.getter(MonitorDataSource::datasetImportJobArn)).setter(MonitorDataSource.setter(Builder::datasetImportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArn").build()}).build();
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastArn").getter(MonitorDataSource.getter(MonitorDataSource::forecastArn)).setter(MonitorDataSource.setter(Builder::forecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()}).build();
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorArn").getter(MonitorDataSource.getter(MonitorDataSource::predictorArn)).setter(MonitorDataSource.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_ARN_FIELD, FORECAST_ARN_FIELD, PREDICTOR_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitorDataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetImportJobArn;
    private final String forecastArn;
    private final String predictorArn;

    private MonitorDataSource(BuilderImpl builder) {
        this.datasetImportJobArn = builder.datasetImportJobArn;
        this.forecastArn = builder.forecastArn;
        this.predictorArn = builder.predictorArn;
    }

    public final String datasetImportJobArn() {
        return this.datasetImportJobArn;
    }

    public final String forecastArn() {
        return this.forecastArn;
    }

    public final String predictorArn() {
        return this.predictorArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetImportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorDataSource)) {
            return false;
        }
        MonitorDataSource other = (MonitorDataSource)obj;
        return Objects.equals(this.datasetImportJobArn(), other.datasetImportJobArn()) && Objects.equals(this.forecastArn(), other.forecastArn()) && Objects.equals(this.predictorArn(), other.predictorArn());
    }

    public final String toString() {
        return ToString.builder((String)"MonitorDataSource").add("DatasetImportJobArn", (Object)this.datasetImportJobArn()).add("ForecastArn", (Object)this.forecastArn()).add("PredictorArn", (Object)this.predictorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetImportJobArn": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobArn()));
            }
            case "ForecastArn": {
                return Optional.ofNullable(clazz.cast(this.forecastArn()));
            }
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DatasetImportJobArn", DATASET_IMPORT_JOB_ARN_FIELD);
        map.put("ForecastArn", FORECAST_ARN_FIELD);
        map.put("PredictorArn", PREDICTOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorDataSource, T> g) {
        return obj -> g.apply((MonitorDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetImportJobArn;
        private String forecastArn;
        private String predictorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorDataSource model) {
            this.datasetImportJobArn(model.datasetImportJobArn);
            this.forecastArn(model.forecastArn);
            this.predictorArn(model.predictorArn);
        }

        public final String getDatasetImportJobArn() {
            return this.datasetImportJobArn;
        }

        public final void setDatasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
        }

        @Override
        public final Builder datasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
            return this;
        }

        public final String getForecastArn() {
            return this.forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public MonitorDataSource build() {
            return new MonitorDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitorDataSource> {
        public Builder datasetImportJobArn(String var1);

        public Builder forecastArn(String var1);

        public Builder predictorArn(String var1);
    }
}

